<?php
if ( array_shift( get_included_files() ) === __FILE__) {
	die( file_get_contents( "forbidden.txt" ) );
}

/* =====================================================
	共通宣言部
 ===================================================== */
define( 'MAINDB_DSN', 'sqlite:./db/emailhub.db' );
define( 'SESSION_ID', strtoupper( md5( 'SESSION' . basename(__DIR__) ) ) );
$versionText = 'version.txt';
$version = "";
if ( ( file_exists( $versionText ) ) ) {
	$lines = file( $versionText, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
	$version = "Ver.{$lines[ 0 ]} ";
}
$copyright = "Smart mailbox manager {$version}Copyright &copy; 2023-" . date( 'Y' ) . " Web Studio NOHARA Network";
$demoMode = false;

/* =====================================================
	基本情報セットアップ
 ===================================================== */
$documentRoot = $_SERVER[ 'DOCUMENT_ROOT' ];
$userRoot = preg_replace( '/\/\w+?\/$/', '', $documentRoot );
$domainName = $_SERVER['HTTP_HOST'];
if ( $demoMode ) {
	$fmlPath = "./misc/demo/ml";
	$mailPath = "./misc/demo/MailBox";
	$exampleDomain = "example.sakura.ne.jp";
} else {
	$fmlPath = "$userRoot/fml/spool/ml";
	$mailPath = "$userRoot/MailBox";
}
$selfUriQuery = ( empty( $_SERVER["HTTPS"] ) ? "http://" : "https://" ) . $_SERVER["HTTP_HOST"] . $_SERVER["REQUEST_URI"];
$selfUri = strtok( $selfUriQuery, '?' );
$scriptHomeUri = preg_replace( '/(\/[^\/]+\.php|\/+)$/i', '', $selfUri );
$selfName = basename(__FILE__);
$mainTitle = 'Smart Mailbox Manager';

function addUpdateQuery( $fileName ) {
	if ( $timeStamp = filemtime( $fileName ) ) {
		echo $fileName . "?ver=" . $timeStamp;
	} else {
		echo $fileName;
	}
}

//
// getPropertyBool
// キーが存在しない場合にはFALSEが返される
//
function getPropertyBool( $propertyName ) {
	$result = getProperty( $propertyName );
	return in_array( strtoupper( $result ), array( 'YES', 'ON', 'TRUE', 1 ) );
}

//
// getProperty
// キーが存在しない場合にはNULLが返される
//
function getProperty( $propertyName ) {
	try {
		$pdo = new PDO( MAINDB_DSN );
		$stmt = $pdo->prepare( "SELECT value FROM property WHERE key=?" );
		$stmt->execute( Array( $propertyName ) );
		$row = $stmt->fetch();
		$result = $row[ "value" ];
		$pdo = null;
		return $result;
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
}

function getProperties( $propertyName ) {	// name + nn
	try {
		$pdo = new PDO( MAINDB_DSN );
		$sql = "SELECT value FROM property WHERE key glob '{$propertyName}[1-9]';";
		$stmt = $pdo->query( $sql );
		$result = $stmt->fetchAll( PDO::FETCH_ASSOC );
		$pdo = null;
		return array_column( $result, 'value' );
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
}

function setProperty( $propertyName, $value ) {
	try {
		$pdo = new PDO( MAINDB_DSN );
		$stmt = $pdo->prepare( "INSERT INTO property ( key, value ) VALUES ( :key, :value1 ) ON CONFLICT ( key ) DO UPDATE SET value=:value2;" );
		$stmt->bindValue( ":key", $propertyName, PDO::PARAM_STR );
		$stmt->bindValue( ":value1", $value, PDO::PARAM_STR );
		$stmt->bindValue( ":value2", $value, PDO::PARAM_STR );
		$stmt->execute();
		$pdo = null;
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
}

function deleteProperty( $propertyName ) {
	try {
		$pdo = new PDO( MAINDB_DSN );
		$stmt = $pdo->prepare( "DELETE FROM property WHERE key=:key;" );
		$stmt->bindValue( ":key", $propertyName, PDO::PARAM_STR );
		$stmt->execute();
		$pdo = null;
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
}

function appendUser( $userName, $password, $authority, $option ) {
	try {
		$pdo = new PDO( MAINDB_DSN );
		$stmt = $pdo->prepare( "SELECT * FROM signin_info WHERE user=?;" );
		$stmt->execute( Array( $userName ) );
		$count = (int) $stmt->fetchColumn();
		if ( $count > 0 ) return false;
		$stmt = $pdo->prepare( "INSERT INTO signin_info ( user, password, root, option ) VALUES ( :user, :password, :root, :option );" );
		$stmt->bindValue( ":user", $userName, PDO::PARAM_STR );
		$stmt->bindValue( ":password", password_hash( $password, PASSWORD_DEFAULT ), PDO::PARAM_STR );
		$stmt->bindValue( ":root", $authority, PDO::PARAM_INT );
		$stmt->bindValue( ":option", $option, PDO::PARAM_INT );
		$stmt->execute();
		return true;
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	} finally {
		$pdo = null;
	}
}

function getUserName( $userId ) {
	try {
		$pdo = new PDO( MAINDB_DSN );
		$stmt = $pdo->prepare( "SELECT user_name FROM signin_info WHERE user=?;" );
		$stmt->execute( Array( $userId ) );
		$row = $stmt->fetch();
		$pdo = null;
		return $row[ "user_name" ];
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
}

function getPassword( $userId ) {
	try {
		$pdo = new PDO( MAINDB_DSN );
		$stmt = $pdo->prepare( "SELECT password FROM signin_info WHERE user=?;" );
		$stmt->execute( Array( $userId ) );
		$row = $stmt->fetch();
		$pdo = null;
		return $row[ "password" ];
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
}

function isRoot( $userId ) {
	try {
		$pdo = new PDO( MAINDB_DSN );
		if ( $userId == '*' ) {
			//
			// root権限をもったユーザがいるか？
			//
			$sql = "SELECT * FROM signin_info WHERE root=1;";
			$stmt = $pdo->query( $sql );
			$count = (int) $stmt->fetchColumn();
			return ( $count > 0 ) ? true : false;
		} else {
			//
			// このユーザーのroot権限を返す
			//
			$sql = "SELECT root FROM signin_info WHERE user='{$userId}';";
			$stmt = $pdo->query( $sql );
			$row = $stmt->fetch();
			return ( $row[ 'root' ] == 1 ) ? true : false;
		}
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	} finally {
		$pdo = null;
	}
}

function validateToken( $token ) {
	try {
		$unixTime = time();
		$pdo = new PDO( MAINDB_DSN );
		$expireTime = $unixTime - 300;
		$stmt = $pdo->prepare( "DELETE FROM token WHERE time < ?;" );
		$stmt->execute( array( $expireTime ) );
		$stmt = $pdo->prepare( "SELECT * FROM token WHERE token=?;" );
		$stmt->execute( array( $token ) );
		$count = (int) $stmt->fetchColumn();
		if ( $count > 0 ) {
			$stmt = $pdo->prepare( "DELETE FROM token WHERE token=?;" );
			$stmt->execute( array( $token ) );
			return true;
		} else {
			return false;
		}
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	} finally {
		$pdo = null;
	}
}

function dumpVar( $data ) {
	ob_start();
	var_dump( $data );
	$dump = ob_get_contents();
	ob_end_clean();
	file_put_contents( "./log.txt", $dump );
}
?>
