$( document ).ready( function(){

	//
	// tablesorterのソート設定記憶
	//
	var s = [[0, 0]];
	if(typeof $.cookie('tablesorterIndex') == "string" && typeof $.cookie('tablesorterSort') == "string") {
		s = [[$.cookie('tablesorterIndex'), $.cookie('tablesorterSort')]];
	}
	$('#listview').tablesorter({
		sortList : s
	}).bind('sortEnd', function(e){
		$(this).find('th').each(function(index){
			if($(this).hasClass('tablesorter-headerUnSorted')) {
			return true;
		}
		$.cookie('tablesorterIndex', index, { expires : 1 });
		$.cookie('tablesorterSort', $(this).hasClass('tablesorter-headerAsc') ? '0' : '1', { expires : 1 });
		return false;
		});
	});

	//
	// パスワード表示トグル
	//
	$( '.toggle-pass' ).on( 'click', function() {
		$( this ).toggleClass( 'fa-eye fa-eye-slash' );
		var input = $( this ).prev( 'input' );
		if ( input.attr( 'type' ) == 'text' ) {
			input.attr( 'type', 'password' );
		} else {
			input.attr( 'type', 'text' );
		}
	});

	//
	// mailbox.phpでハッシュタグがあった場合の処理
	//
	if ( $( 'body#mailbox_admin' ).length ) {
		var urlHash = location.hash;
		$( urlHash + "_members" ).css( "display", "block" );
	}

	//
	// メールボックスのメール一覧をトグル表示
	//
	$( '.section_title' ).on( "click", function() {
		$( "#" + $( this ).attr( "id" ) + "_members" ).slideToggle();
	});

	//
	// tablesorterの紐づけ
	//
	$( 'table.listview' ).each( function() { $( "#" + $( this ).attr( "id" ) ).tablesorter(); } );

	//
	// あかさたなで絞り込み
	//
	$( 'a.aiueo_filters' ).on( "click", function() {
		var aiueoClasses = [ "yomi_a", "yomi_ka", "yomi_sa", "yomi_ta", "yomi_na", "yomi_ha", "yomi_ma", "yomi_ya", "yomi_ra", "yomi_wa", "yomi_none" ];
		var key = $( this ).attr( "id" );
		var len = aiueoClasses.length;
		for ( var i = 0; i < len; i++ ) $( "table#listview tr." + aiueoClasses[ i ] ).show();
		if ( key == "yomi_all" ) return false;
		for ( var i = 0; i < len; i++ ) {
			if ( aiueoClasses[ i ] != key ) {
				$( "table#listview tr." + aiueoClasses[ i ] ).hide();
			}
		}
		return false;
	});

//	//
//	// Envelope Fromモディファイフィルターの設定／解除 ==> 廃止
//	//
//	$( 'input#set_mod_envelope' ).on( "click", function() {
//		var sendData = {};
//		var prompt;
//		if ( $( this ).prop( "checked" ) ) {
//			sendData[ "value" ] = 'ON';
//			prompt = "すべての転送先にGmail転送の対策設定します。";
//		} else {
//			sendData[ "value" ] = 'OFF';
//			prompt = "すべての転送先からGmail転送の対策を解除します。";
//		}
//		if ( confirm( prompt ) ) {
//			sendData[ "func" ] = 'SET_MOD_ENVELOPE';
//			let showUpdated = function( result ){
//				if ( result.status == "ON" ) {
//					$( "#status_area01" ).html( "転送対策を設定しました：" );
//				}
//				else if ( result.status == "OFF" ) {
//					$( "#status_area01" ).html( "転送対策を解除しました：" );
//				} else {
//					$( "#status_area01" ).html( result.status + "：" );
//				}
//				statusClear( "#status_area01" );
//				setTimeout(
//					function(){
//						window.location.reload();
//					}, 1000
//				);
//			}
//			ajaxQuery( sendData, "#status_area01", showUpdated );
//		} else {
//			return false;
//		}
//		return true;
//	});

	//
	// 当該メールアドレス未登録のCC/FMLアカウントを表示させる（トグル動作）
	//
	$( 'a.link_button' ).on( "click", function() {
		var pattern = /^show_all_cc(\d+)$/;
		var id = $( this ).attr( "id" );
		var i = id.replace( pattern, "$1" );
		if ( pattern.test( id ) ) {
			$( "#cc" + i + " li.not_registerated" ).slideToggle();
			return false;
		}
		var pattern = /^show_all_fml(\d+)$/;
		var id = $( this ).attr( "id" );
		var i = id.replace( pattern, "$1" );
		if ( pattern.test( id ) ) {
			$( "#ml" + i + " li.not_registerated" ).slideToggle();
			return false;
		}
	});

	// ===================================== シングルビュー画面ハンドラ ============

	//
	// シングルビューでユーザーのメールアドレスの追加
	//
	$( 'button#email_insert' ).on( "click", function() {
		var sendData = {};
		sendData[ "func" ] = 'INSERT_EMAIL';
		sendData[ "user_id" ] = $( "input#user_id" ).val();
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		sendData[ 'set' ] = {};
		var email = $( "input#email_new" ).val();
		var pattern = /^[a-zA-Z0-9]+[a-zA-Z0-9\._-]*@[a-zA-Z0-9_-]+[a-zA-Z0-9\._-]+$/;
		if ( pattern.test( email ) ) {
			sendData[ 'set' ][ 'email' ] = email;
			let showUpdated = function( result ){
				$( "input#email_new" ).css( "background-color", "pink" );
				if ( result.status == "EXISTS_ERROR" ) {
					$( "#status_area01" ).html( "<span style=\"color: red;\">すでに登録済みのアドレスです。</span>" );
					statusClear( 'email_new' );
					return false;
				}
				$( "#status_area01" ).html( "登録完了" );
				$( "input#email_new_org" ).val( $( "input#email_new" ).val() );
				statusClear( "email_new" );
				if ( result.user_id !== undefined ) {
					setTimeout(
						function(){
							window.location.href = window.location.href.replace( /\?.*$/, "" ) + '?view_id=' + result.user_id;
						}, 1000
					);
				}
			}
			ajaxQuery( sendData, "#status_area01", showUpdated );
		} else {
			$( "#status_area01" ).html( "<span style='color: red'>E-mailアドレスの形式ではありません。</span>" );
			$( "input#email_new" ).css( 'background-color', 'pink' );
			statusClear( 'email_new' );
		}
	});

	//
	// シングルビューの個人情報の登録／編集
	//
	$( 'button#save_person_info' ).on( "click", function() {
		var userId = $( "input#user_id" ).val();
		var sendData = {};
		if ( userId == "0" )  {
			sendData[ "func" ] = 'INSERT';
		} else {
			sendData[ "func" ] = 'UPDATE';
		}
		sendData[ "user_id" ] = userId;
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		sendData[ 'set' ] = {};
		var i = 0;
		$( 'input[type="text"]' ).each( function() {
			orgValue = $( "input#" + $( this ).attr( "id" ) + "_org" ).val();
			hotValue = sanitize( $( this ).val() );
			// 編集済みの項目を検出する
			if ( orgValue !== undefined && orgValue != hotValue ) {
				sendData.set[ $( this ).attr( "id" ) ] = hotValue;
				i++;
			}
		});
		if ( i == 0 ) {
			$( "#status_area01" ).html( "更新された項目がありません。" );
			statusClear( '#status_area01' );
			return false;
		} else {
			let showUpdated = function( result ){
				if ( result.updated !== undefined ) {
					$( "#status_area01" ).html( "登録完了" );
					var inputArea;
					for ( let key in result.updated ) {
						$( "input#user_id" ).val( result.user_id );
						inputArea = "input#" + key;
						$( inputArea + "_org" ).val( result.updated[ key ] );
						$( inputArea ).css( "background-color", "pink" );
						updateSignClear( inputArea, "#status_area01" );
					}
					if ( result.user_id !== undefined ) {
						setTimeout(
							function(){
								window.location.href = window.location.href.replace( /\?.*$/, "" ) + '?view_id=' + result.user_id;
							}, 1000
						);
					}
				}
			}
			ajaxQuery( sendData, "#status_area01", showUpdated );
		}
	});
	$( 'input[readonly="readonly"]' ).on( "click", function() {
		$( "#status_area01" ).html( "<span style='color: red'>その項目は編集できません。</span>" );
		statusClear( "#status_area01" );
		return false;
	});

	//
	// シングルビューの個人情報の削除
	//
	$( 'a#delete_button' ).on( "click", function() {
		var existsChecked = false;
		$( "ul.address_list input.registration" ).each( function( index ) {
			if ( $( this ).prop( "checked" ) ) {
				existsChecked = true;
				return false;
			}
		});
		if ( existsChecked ) {
			alert( "すべての転送設定を解除してからメールアドレスを削除して下さい。" );
			$( "#status_area01" ).html( "キャンセルしました" );
			statusClear( "#status_area01" );
			return false;
		}
		if ( confirm( "この登録を削除しますが、よろしいですか？\n登録されたメールアドレスも消去します。" ) ) {
			//
			// CC, ML, etc.の登録も削除するのが課題
			//
			var userId = $( "input#user_id" ).val();
			var sendData = {};
			sendData[ "user_id" ] = userId;
			sendData[ "func" ] = 'DELETE';
			sendData[ "signin_id" ] = $( "input#signin_id" ).val();
			sendData[ "signin_user" ] = $( "input#signin_user" ).val();
			let showResult = function( result ){
				if ( result.status == "SUCCESS" ) {
					$( "#status_area01" ).html( "削除完了" );
					setTimeout(
						function(){
							window.location.href = window.location.href.replace( /\?.*$/, "" ) + '?view_id=0';
						}, 1000
					);
				}
			}
			ajaxQuery( sendData, "#status_area01", showResult );
		} else {
			$( "#status_area01" ).html( "キャンセルしました。" );
			statusClear( "#status_area01" );
		}
		return false;
	});

	//
	// メールアドレス削除（シングルビュー）
	//
	$( 'a.mail_delete_button' ).on( "click", function() {
		var userId = $( "input#user_id" ).val();
		var thisId = $( this ).attr( "id" );
		var i = thisId.replace( /^[^\d]+(\d+)$/, "$1" );
		var email = $( "input#email" + i ).val();
		var existsChecked = false;
		$( "li#alis" + i + " input.registration" ).each( function( index ) {
			if ( $( this ).prop( "checked" ) ) {
				existsChecked = true;
				return false;
			}
		});
		if ( existsChecked ) {
			alert( "すべての転送設定を解除してからメールアドレスを削除して下さい。" );
			$( "#status_area01" ).html( "キャンセルしました" );
			statusClear( "#status_area01" );
			return false;
		}
		if ( confirm( "このメールアドレスを登録解除しますが、よろしいですか？" ) ) {
			var sendData = {};
			sendData[ "signin_id" ] = $( "input#signin_id" ).val();
			sendData[ "signin_user" ] = $( "input#signin_user" ).val();
			sendData[ "user_id" ] = userId;
			sendData[ "email" ] = email;
			sendData[ "func" ] = 'DELETE_EMAIL';
			let showResult = function( result ){
				if ( result.status == "SUCCESS" ) {
					$( "#status_area01" ).html( "削除完了" );
					setTimeout(
						function(){
							window.location.reload();
						}, 1000
					);
				}
			}
			ajaxQuery( sendData, "#status_area01", showResult );
		} else {
		}
		$( "#status_area01" ).html( "キャンセルしました。" );
		statusClear( "#status_area01" );
		return false;
	});

	//
	// シングルビューFMLのチェックボックスクリックでメールアドレス登録解除
	//
	$( 'ul.ml input.registration' ).on( "click", function() {
		var sendData = {};
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		sendData[ "account" ] = $( this ).val();
		sendData[ "list_id" ] = $( this ).attr( "id" ).replace( /^[^\d]+(\d+_\d+)$/, "$1" );
		var i = sendData.list_id.replace( /(\d+)_\d+$/, "$1" );
		sendData[ "email" ] = $( "#email" + i ).val();
		sendData[ "status_area" ] = "span#status_fml" + i;
		if ( $( this ).prop( "checked" ) ) {
			$( this ).prop( "checked", false ).change();			// on clickイベントが発生した時点で反転しているので戻しておく
			sendData[ "func" ] = 'APPEND_FML';
		} else {
			$( this ).prop( "checked", true ).change();
			sendData[ "func" ] = 'DELETE_FML';
		}
		let showResult = function( result ){
			if	( result.status == "APPENDED" ) {
				$( "#registration" + result.list_id ).prop( "checked", true ).change();
				$( sendData.status_area ).html( "登録完了" );
			}
			else if	( result.status == "DELETED" ) {
				$( "#registration" + result.list_id ).prop( "checked", false ).change();
				$( sendData.status_area ).html( "削除完了" );
			} else {
				$( sendData.status_area ).html( "更新できませんでした：" + result.status );
			}
			statusClear( sendData.status_area );
		}
		ajaxQuery( sendData, sendData.status_area, showResult );
	});

	//
	// シングルビューCCのチェックボックスクリックでメールアドレス登録解除
	//
	$( 'ul.cc input.registration' ).on( "click", function() {
		var sendData = {};
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		sendData[ "account" ] = $( this ).val();
		sendData[ "list_id" ] = $( this ).attr( "id" ).replace( /^[^\d]+(\d+_\d+)$/, "$1" );
		var i = sendData.list_id.replace( /(\d+)_\d+$/, "$1" );
		sendData[ "email" ] = $( "#email" + i ).val();
		sendData[ "status_area" ] = "span#status_cc" + i;
		if ( $( this ).prop( "checked" ) ) {
			$( this ).prop( "checked", false ).change();			// on clickイベントが発生した時点で反転しているので戻しておく
			sendData[ "func" ] = 'APPEND_CC';
		} else {
			$( this ).prop( "checked", true ).change();
			sendData[ "func" ] = 'DELETE_CC';
		}
		let showResult = function( result ){
//			if	( result.status == "APPENDED" || result.status == "APPENDED_MOD_ENVELOPE" ) {
			if	( result.status == "APPENDED" ) {
				$( "#registration" + result.list_id ).prop( "checked", true ).change();
				$( sendData.status_area ).html( "登録完了" );
			}
			else if	( result.status == "DELETED" ) {
				$( "#registration" + result.list_id ).prop( "checked", false ).change();
				$( sendData.status_area ).html( "削除完了" );
			} else {
				$( sendData.status_area ).html( "更新できませんでした：" + result.status );
			}
			statusClear( sendData.status_area );
		}
		ajaxQuery( sendData, sendData.status_area, showResult );
	});

	// =============================== メールボックスリスト画面ハンドラ ============

	// ----- FML ---------------------------

	//
	// FMLカスタマイズインジケーター更新
	//
	if ( $( 'input#fml_customize_count' ).val() > 0 ) {
		$( 'input#fml_customize' ).prop( 'checked', true ).change();
	} else {
		$( 'input#fml_customize' ).prop( 'checked', false ).change();
	}
	//
	// FMLカスタマイズ設定／解除
	//
	$( 'input#fml_customize' ).on( 'click', function() {
		var sendData = {};
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		if ( $( this ).prop( 'checked' ) ) {
			$( this ).prop( "checked", false ).change();			// on clickイベントが発生した時点で反転しているので戻しておく
			if ( !confirm( "FMLにオプションを設定します。よろしいですね？" ) ) return false;
			sendData[ "func" ] = 'FML_CUSTOMIZE';
		} else {
			$( this ).prop( "checked", true ).change();
			if ( !confirm( "FMLのオプションを解除します。よろしいですね？" ) ) return false;
			sendData[ "func" ] = 'FML_NORMALIZE';
		}
		let showResult = function( result ){
			window.location.reload();
		}
		ajaxQuery( sendData, sendData.status_area, showResult );
		return false;
	});

	//
	// メールボックスでのFMLの登録（DB整合）
	//
	$( '#fml_block a.register_fml' ).on( "click", function() {
		var sendData = {};
		sendData[ "func" ] = 'APPEND_FML';
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		var indexNums = $( this ).attr( "id" ).replace( /^[^\d]+(\d+_\d+)$/, "$1" );
		var index = indexNums.replace( /^(\d+)_\d+$/, "$1" );
		sendData[ "email" ] = $( "td#fml_mail_address" + indexNums + ">span.email" ).text();
		sendData[ "account" ] = $( "input#fml_account" + index ).val();
		sendData[ "list_id" ] = "tr#list_fml" + indexNums;
		sendData[ "status_area" ] = "span#fml_status_area" + index;
		var msg = "[ " + sendData.email + " ] : ";
		msg = msg + "このアドレスをマネージャーに登録してサーバーと整合させます。";
		if ( !confirm( msg ) ) {
			$( sendData.status_area ).html( "キャンセルしました" );
			statusClear( sendData.status_area );
			return false;
		}
		let showResult = function( result ){
			if ( result.status == "APPENDED" ) {
//				$( "#mod_envelope" + result.list_id ).prop( "checked", true ).change();
				$( result.status_area ).html( "登録完了" );
				$( result.list_id + " div.option_controls" ).hide();
				$( result.list_id ).removeClass( "server_side_only" );
				$( result.list_id ).removeClass( "db_side_only" );
				var msg = "[ " + result.email + " ] : ";
				msg = msg + "このアドレスの所有者がマネージャーに登録済みであれば、そのユーザーの画面でアドレスを追加してください。";
				msg = msg + "\n\n";
				msg = msg + "所有者が未登録であれば、所有者をユーザーとして新規登録してからアドレスを追加します。";
				msg = msg + "\n\n";
				msg = msg + "このアドレスをクリップボードにコピーし、ユーザー登録画面を開きます。";
				if ( navigator.clipboard ) {
					navigator.clipboard.writeText( result.email );
				}
				if ( confirm( msg ) ) {
					window.location = "members.php?view_id=0";
				}
			} else {
				$( result.status_area ).html( "登録できませんでした：" + result.status );
			}
			statusClear( result.status_area );
		}
		ajaxQuery( sendData, sendData.status_area, showResult );
		return false;
	});

	//
	// メールボックス一覧でFMLの登録解除
	//
	$( '#fml_block a.delete_fml' ).on( "click", function() {
		var sendData = {};
		sendData[ "func" ] = 'DELETE_FML';
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		var indexNums = $( this ).attr( "id" ).replace( /^[^\d]+(\d+_\d+)$/, "$1" );
		var index = indexNums.replace( /^(\d+)_\d+$/, "$1" );
		sendData[ "email" ] = $( "td#fml_mail_address" + indexNums + ">span.email" ).text();
		sendData[ "account" ] = $( "input#fml_account" + index ).val();
		sendData[ "list_id" ] = "tr#list_fml" + indexNums;
		sendData[ "count_id" ] = "span#count_fml" + index;
		sendData[ "status_area" ] = "#fml_status_area" + index;
		if ( !confirm( "登録を解除します（ユーザー登録情報は消えません）" ) ) {
			$( sendData.status_area ).html( "キャンセルしました" );
			statusClear( sendData.status_area );
			return false;
		}
		let showResult = function( result ){
			if ( result.status_area == undefined ) return false;
			if	( result.status == "DELETED" ) {
				$( result.status_area ).html( "削除完了" );
				$( result.list_id ).removeClass( "server_side_only" );
				$( result.list_id ).removeClass( "db_side_only" );
				$( result.list_id ).hide();
				$( result.count_id ).text( String( $( result.count_id ).text() - 1 ) );
			}
			else if	( result.status == "ALREADY_DELETED" ) {
				$( result.status_area ).html( "登録がありません" );
				$( result.list_id ).hide();
				$( result.count_id ).text( String( $( result.count_id ).text() - 1 ) );
			} else {
				$( result.status_area ).html( "予期しない結果：" + result.status );
			}
			statusClear( result.status_area );
		}
		ajaxQuery( sendData, sendData.status_area, showResult );
		return false;
	});

	//
	// メーリングリストのコメント編集（オプション）
	//
	$( '.fml_comment' ).on( "click", function() {
		var thisId = "#" + $( this ).attr( "id" );
		var i = thisId.replace( /^#fml_comment(\d+)$/, "$1" );
		var account = $( "#fml_account" + i ).val();
		var comment = $( thisId ).text();
		var nocomment = "[コメントがありません]";
		if ( comment == nocomment ) {
			comment = "";
		}
		var result = window.prompt( account + "：コメントを編集できます", comment );
		if ( result != "" && result == null ) {
			return false;
		}
		else if ( result == comment ){
			return false;
		}
		var sendData = {};
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		sendData[ "func" ] = 'SET_FML_COMMENT';
		sendData[ "comment" ] = result;
		sendData[ "comment_id" ] = thisId;
		sendData[ "status_area" ] = "#fml_status_area" + i;
		sendData[ "account" ] = account;
		let showResult = function( result ){
			if ( result.status == "SUCCESS" ) {
				if ( result.comment == "" ) {
					result.comment = nocomment;
				}
				$( result.comment_id ).text( result.comment );
			}
			$( result.status_area ).text( result.status );
			statusClear( result.status_area );
		}
		ajaxQuery( sendData, sendData.status_area, showResult );
		return false;
	});

	// ----- MailBox CC --------------------

	//
	// メールボックスでメールアドレスCC登録（データ整合）
	//
	$( '#mail_block a.register_cc' ).on( "click", function() {
		var sendData = {};
		sendData[ "func" ] = 'APPEND_CC';
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		var indexNums = $( this ).attr( "id" ).replace( /^[^\d]+(\d+_\d+)$/, "$1" );
		var index = indexNums.replace( /^(\d+)_\d+$/, "$1" );
		sendData[ "email" ] = $( "td#cc_mail_address" + indexNums + ">span.email" ).text();
		sendData[ "account" ] = $( "input#cc_account" + index ).val();
		sendData[ "list_id" ] = "tr#list_cc" + indexNums;
		sendData[ "status_area" ] = "span#status_cc" + index;
		var msg = "[ " + sendData.email + " ] : ";
		msg = msg + "このアドレスをマネージャーに登録してサーバーと整合させます。";
		if ( !confirm( msg ) ) {
			$( sendData.status_area ).html( "キャンセルしました" );
			statusClear( sendData.status_area );
			return false;
		}
		let showResult = function( result ){
//			if	( result.status == "APPENDED" || result.status == "APPENDED_MOD_ENVELOPE" ) {
			if ( result.status == "APPENDED" ) {
//				$( "#mod_envelope" + result.list_id ).prop( "checked", false ).change();
				$( result.status_area ).html( "登録完了" );
				$( result.list_id + " div.option_controls" ).hide();
				$( result.list_id ).removeClass( "server_side_only" );
				$( result.list_id ).removeClass( "db_side_only" );
				var msg = "[ " + result.email + " ] : ";
				msg = msg + "このアドレスの所有者がマネージャーに登録済みであれば、そのユーザーの画面でアドレスを追加してください。";
				msg = msg + "\n\n";
				msg = msg + "所有者が未登録であれば、所有者をユーザーとして新規登録してからアドレスを追加します。";
				msg = msg + "\n\n";
				msg = msg + "このアドレスをクリップボードにコピーし、ユーザー登録画面を開きます。";
				if ( navigator.clipboard ) {
					navigator.clipboard.writeText( result.email );
				}
				if ( confirm( msg ) ) {
					window.location = "members.php?view_id=0";
				}
			} else {
				$( result.status_area ).html( "登録できませんでした：" + result.status );
			}
			statusClear( result.status_area );
		}
		ajaxQuery( sendData, sendData.status_area, showResult );
		return false;
	});

	//
	// メールボックス一覧でCCメールアドレス削除
	//
	$( '#mail_block a.delete_cc' ).on( "click", function() {
		var sendData = {};
		sendData[ "func" ] = 'DELETE_CC';
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		var indexNums = $( this ).attr( "id" ).replace( /^[^\d]+(\d+_\d+)$/, "$1" );
		var index = indexNums.replace( /^(\d+)_\d+$/, "$1" );
		sendData[ "email" ] = $( "td#cc_mail_address" + indexNums + ">span.email" ).text();
		sendData[ "account" ] = $( "input#cc_account" + index ).val();
		sendData[ "list_id" ] = "tr#list_cc" + indexNums;
		sendData[ "count_id" ] = "span#count_cc" + index;
		sendData[ "status_area" ] = "#cc_status_area" + index;
		if ( !confirm( "登録を解除します（ユーザー登録情報は消えません）" ) ) {
			$( sendData.status_area ).html( "キャンセルしました" );
			statusClear( sendData.status_area );
			return false;
		}
		let showResult = function( result ){
			if ( result.status_area == undefined ) return false;
			if	( result.status == "DELETED" ) {
				$( result.status_area ).html( "削除完了" );
				$( result.list_id ).removeClass( "server_side_only" );
				$( result.list_id ).removeClass( "db_side_only" );
				$( result.list_id ).hide();
				$( result.count_id ).text( String( $( result.count_id ).text() - 1 ) );
			}
			else if	( result.status == "ALREADY_DELETED" ) {
				$( result.status_area ).html( "登録がありません" );
				$( result.list_id ).hide();
				$( result.count_id ).text( String( $( result.count_id ).text() - 1 ) );
			} else {
				$( result.status_area ).html( "予期しない結果：" + result.status );
			}
			statusClear( result.status_area );
		}
		ajaxQuery( sendData, sendData.status_area, showResult );
		return false;
	});

	//
	// メールボックスのコメント編集
	//
	$( '.mailbox_comment' ).on( "click", function() {
		var thisId = "#" + $( this ).attr( "id" );
		var i = thisId.replace( /^#cc_comment(\d+)$/, "$1" );
		var account = $( "#cc_account" + i ).val();
		var comment = $( thisId ).text();
		var nocomment = "[コメントがありません]";
		if ( comment == nocomment ) {
			comment = "";
		}
		var result = window.prompt( account + "：コメントを編集できます", comment );
		if ( result != "" && result == null ) {
			return false;
		}
		else if ( result == comment ){
			return false;
		}
		var sendData = {};
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		sendData[ "func" ] = 'SET_MAILBOX_COMMENT';
		sendData[ "comment" ] = result;
		sendData[ "comment_id" ] = thisId;
		sendData[ "status_area" ] = "#cc_status_area" + i;
		sendData[ "account" ] = account;
		let showResult = function( result ){
			if ( result.status == "SUCCESS" ) {
				if ( result.comment == "" ) {
					result.comment = nocomment;
				}
				$( result.comment_id ).text( result.comment );
			}
			$( result.status_area ).text( result.status );
			statusClear( result.status_area );
		}
		ajaxQuery( sendData, sendData.status_area, showResult );
		return false;
	});

	// =============================== 管理画面ハンドラ ====================

	//
	// プロパティのブール値入力支援
	//
	$( 'input.bool_assist' ).on( "dblclick", function() {
		var boolSet = { 'ON' : 'OFF', 'YES' : 'NO', 'TRUE' : 'FALSE', '1' : '0' };
		var val = $( this ).val().toUpperCase();
		for ( let key in boolSet) {
			if ( key == val ) {
				$( this ).val( boolSet[ key ] );
				$( this ).removeClass( 'true' );
				$( this ).addClass( 'false' );
				return false;
			}
			else if ( boolSet[ key ] == val ) {
				$( this ).val( key );
				$( this ).removeClass( 'false' );
				$( this ).addClass( 'true' );
				return false;
			}
		}
	});

	//
	// プロパティの登録／編集
	//
	$( 'button#save_property' ).on( "click", function() {
		var i = $( this ).parent().attr( "id" ).replace( /^[^\d]+(\d+)$/, "$1" );
		var sendData = {};
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		sendData[ 'set' ] = {};
		sendData[ 'col' ] = i;
		sendData.set[ 'key' ] = $( "input#key_" + i ).val();
		if ( $( "input#delete_" + i ).prop( 'checked' ) ) {
			sendData[ "func" ] = 'DELETE_PROPERTY';
			sendData.set[ 'value' ] = sanitize( $( "input#value_" + i ).val() );
			sendData.set[ 'comment' ] = sanitize( $( "input#comment_" + i ).val() );
			var result = window.confirm( sendData.set.key + "：このプロパティを削除してよろしいですね？" );
			if ( !result ) {
				$( "#status_area01" ).html( "キャンセルしました。" );
				statusClear( '#status_area01' );
				return false;
			}
		} else {
			sendData[ "func" ] = 'UPDATE_PROPERTY';
			var updated = false;
			if ( $( "input#key_org_" + i ).val() == "*****" ) {
				var regex = /^[a-zA-Z0-9_\-]+$/;
				if ( !regex.test( sendData.set.key ) ) {
					alert( "プロパティ名に使用できるのは半角英数字と ＿－ のみです。" );
					return false;
				}
			}
			item = $( "input#value_" + i ).val();
			if ( $( "input#value_org_" + i ).val() != item ) updated = true;
			sendData.set[ 'value' ] = sanitize( item );
			item = $( "input#comment_" + i ).val();
			if ( $( "input#comment_org_" + i ).val() != item ) updated = true;
			sendData.set[ 'comment' ] = sanitize( item );
			if ( !updated ) {
				$( "#status_area01" ).html( "更新された項目がありません。" );
				statusClear( '#status_area01' );
				return false;
			}
		}
		let showUpdated = function( result ){
			if ( result.updated !== undefined ) {
				if ( result.status == "UPDATED" ) {
					$( "#status_area01" ).html( "登録完了" );
					var inputArea;
					for ( let key in result.updated ) {
						inputArea = "input#" + key + "_" + result.col;
						$( inputArea + "_org" ).val( result.updated[ key ] );
						$( inputArea ).css( "background-color", "pink" );
					}
				} else {
					$( "#status_area01" ).html( "削除完了" );
				}
				updateSignClear( inputArea, "#status_area01" );
				setTimeout(
					function(){
						window.location.reload();
					}, 3000
				);
			}
		}
		ajaxQuery( sendData, "#status_area01", showUpdated );
	});

	//
	// 管理者の登録チェック
	//
	$( 'input.root_user' ).on( "click", function() {
		var rootExists = false;
		$( "input.root_user" ).each( function() {
			if ( $( this ).prop( 'checked' ) ) {
				rootExists = true;
			}
		});
		if ( !rootExists ) {
			alert( "少なくとも1名の管理者登録が必要です。" );
			return false;
		}
		return true;
	});
	$( 'input.del_users' ).on( "click", function() {
		var i = $( this ).attr( "id" ).replace( /^[^\d]+(\d+)$/, "$1" );
		if ( $( "input#del_user_" + i ).prop( 'checked' ) ) {
			var rootCount = 0;
			$( "input.root_user" ).each( function() {
				if ( $( this ).prop( 'checked' ) ) {
					rootCount++;
				}
			});
			if ( rootCount == 1 ) {
				alert( "少なくとも1名の管理者登録が必要です。" );
				return false;
			}
		}
		return true;
	});

	//
	// ユーザーIDの登録／編集
	//
	$( 'button#save_user' ).on( "click", function() {
		var i = $( this ).parent().attr( "id" ).replace( /^[^\d]+(\d+)$/, "$1" );
		var sendData = {};
		sendData[ "signin_id" ] = $( "input#signin_id" ).val();
		sendData[ "signin_user" ] = $( "input#signin_user" ).val();
		sendData[ 'set' ] = {};
		sendData[ 'col' ] = i;
		sendData.set[ 'user' ] = $( "input#user_" + i ).val();
		if ( $( "input#del_user_" + i ).prop( 'checked' ) ) {
			sendData[ "func" ] = 'DELETE_SIGNIN_INFO';
			var result = window.confirm( sendData.set.user + "：このユーザーを削除してよろしいですね？" );
			if ( !result ) {
				$( "#status_area02" ).html( "キャンセルしました。" );
				$( "input#del_user_" + i ).prop( "checked", false ).change();
				statusClear( '#status_area02' );
				return false;
			}
		} else {
			sendData[ "func" ] = 'UPDATE_SIGNIN_INFO';
			var insert = false;
			var updated = false;
			if ( $( "input#root_" + i ).prop( 'checked' ) ) {
				sendData.set[ 'root' ] = "YES";
			} else {
				sendData.set[ 'root' ] = "NO";
			}
			if ( $( "input#user_" + i ).val() == "" ) {
				alert( "必要な情報を入力してください。" );
				return false;
			}
			if ( $( "input#user_org_" + i ).val() == "" ) {
				insert = true;
				var regex = /^[a-zA-Z0-9\._\-]+$/;
				if ( !regex.test( sendData.set.user ) ) {
					alert( "ユーザIDに使用できるのは半角英数字と'._-'のみです。" );
					return false;
				}
			}
			var orgRootCheck = ( $( "input#root_org_" + i ).val() == "TRUE" );
			if ( $( "input#root_" + i ).prop( "checked" ) !== orgRootCheck ) {
				updated = true;
			}
			item = $( "input#user_name_" + i ).val();
			if ( $( "input#user_name_org_" + i ).val() != item ) updated = true;
			sendData.set[ 'user_name' ] = sanitize( item );
			item = $( "input#password_" + i ).val();
			if ( item == "" ) {
				if ( insert ) {
					alert( "必要な情報を入力してください。" );
					return false;
				}
			} else {
				updated = true;
				var regex = /^[a-zA-Z0-9\.\-\_\#\%\$]+$/;
				if ( !regex.test( item ) ) {
					alert( "パスワードに使用できるのは半角英数字と'.-_#%$'のみです。" );
					return false;
				}
			}
			sendData.set[ 'password' ] = sanitize( item );
			if ( !updated ) {
				$( "#status_area02" ).html( "更新された項目がありません。" );
				statusClear( '#status_area02' );
				return false;
			}
		}
		let showUpdated = function( result ){
			if ( result.updated !== undefined ) {
				if ( result.status == "UPDATED" ) {
					$( "#status_area02" ).html( "登録完了" );
					var inputArea;
					for ( let key in result.updated ) {
						inputArea = "input#" + key + "_" + result.col;
						$( inputArea + "_org" ).val( result.updated[ key ] );
						$( inputArea ).css( "background-color", "pink" );
					}
				} else {
					$( "#status_area01" ).html( "削除完了" );
				}
				updateSignClear( inputArea, "#status_area02" );
				setTimeout(
					function(){
						window.location.reload();
					}, 3000
				);
			}
		}
		ajaxQuery( sendData, "#status_area02", showUpdated );
	});

}); // $(document).ready

// =============================== ユーティリティ関数群 ========

//
// ステータスの時限消去
//
function updateSignClear( inputArea, statusArea ) {
	setTimeout(
		function(){
			$( inputArea ).css( "background-color", "white" );
			$( statusArea ).html( "" );
		}, 3000
	);
}
function statusClear( satatusArea ) {
	setTimeout(
		function(){
			$( satatusArea ).html( "" );
		}, 3000
	);
}

//
// HTMLキーワードのサニタイズ
//
function sanitize( str ) {
	return String( str ).replace( /&/g, "&amp;" ).replace( /"/g, "&quot;" ).replace( /</g, "&lt;" ).replace( />/g, "&gt;" );
}

//
// Ajax通信
//
function ajaxQuery( sendData, statusArea, action ) {
	$( statusArea ).html( '通信中' );
	// 通信実行
	$.ajax({
		type: "POST",
		url: "svr.php",
		data: sendData,
		dataType: "json",
		success: function( result ) {		// 200 OK時
			// 成功時処理
			$( statusArea ).html( result[ 'status' ] );
			result[ 'status_area' ] = statusArea;
			action( result );
		},
		error: function() {			// HTTPエラー時
			$( statusArea ).html( "通信エラー" );
		},
		complete: function() {			// 成功・失敗に関わらず通信が終了した際の処理
		}
	});
}
