<?php
if ( array_shift( get_included_files() ) === __FILE__ ) {
	die( file_get_contents( "forbidden.txt" ) );
}
/* =================================================================

	FMLのすべてのアカウントの config.pl に一括してパッチをあてる
	さくらインターネットのレンタルサーバーを想定

	・パッチ済み検出と挿入ポイント検出は正規表現のキーを定義する
	・挿入データはテキスト形式で定義する
	・挿入データ定義のセクションを参照のこと

   ================================================================= */

class customizeFml {
	protected $fmlPath = "";
	protected $customBlockBegin = "################################ custom block begin ################################";
	protected $customBlockEnd =   "################################  custom block end  ################################";
	protected $insertData = array();
	protected $configArray = array();

	function __construct() {

		/* =================================================================
			挿入データ定義
			$i						0から始まるインデックス
			$this->insertData[ $i ][ 'id' ]			コンソールに表示する名称
			$this->insertData[ $i ][ 'exists_check_key' ]		すでに設定されているか判定するためのサーチキー
			$this->insertData[ $i ][ 'insert_point_key' ]		データの挿入ポイントのサーチーキー（この行の後にデータを展開する）
			$this->insertData[ $i ][ 'insert_data' ]		挿入するテキストデータ
			
			FML config.pl カスタムブロック
			1. FML の Reply-to をMLアドレスに固定する（1.があれば不要だが、単体利用のニーズ向けに残しておく）
			   http://www.top--dog.net/toplog/?p=49
			2. Beckyタイプのリプライマーク統合機能を追加するスクリプト
			   https://qiita.com/Qamada_Case_K/items/82813cb3bae952064e41
			3. DKIMを有効にするため、転送ではなく、発信元として配信する
			   https://mekiku.com/view.php?a=89
		   ================================================================= */

		$i = 0;	// 1. --------------------------------------------------------------------------------------------------
			$this->insertData[ $i ][ 'id' ] = 'Reply-To setting';
			$this->insertData[ $i ][ 'exists_check_key' ] = '/^\s*&DEFINE_FIELD_FORCED\(\s*(\'|")Reply-To(\'|")\s*,\s*\$MAIL_LIST\s*\)/i';
			$this->insertData[ $i ][ 'insert_point_key' ] = '/^#\s*&DEFINE_FIELD_FORCED/';
			$this->insertData[ $i ][ 'insert_data' ] = "&DEFINE_FIELD_FORCED( 'Reply-To', \$MAIL_LIST );";
		$i++;	// 2. --------------------------------------------------------------------------------------------------
			$this->insertData[ $i ][ 'id' ] = 'Becky type bracket';
			$this->insertData[ $i ][ 'exists_check_key' ] = '{^# https://qiita\.com/Qamada_Case_K/items/82813cb3bae952064e41}';
			$this->insertData[ $i ][ 'insert_point_key' ] = '/^# YOU CAN EDIT MANUALLY AFTER HERE\./';
			$this->insertData[ $i ][ 'insert_data' ] = <<<'EOS'
				# Becky type Bracket
				# 2024/04/21 customized by msat
				# https://qiita.com/Qamada_Case_K/items/82813cb3bae952064e41
				$START_HOOK .= q{
					use Encode qw(decode);
					use Jcode;
					my( $title, $subject, $res, $reCount, @re );
				
					$subject = $Envelope{'h:subject:'} ;
					$subject = decode ('MIME-header', $subject) ;
					$subject =~ s/\[${BRACKET}:[0-9]+\]//g;
				
					$reCount = 0;
					if ( $subject =~ s/\s*Re\[(\d+)\]://i ) {
						$reCount = $1 + 0;
					}
					if ( $subject =~ s/^(.*Re:)\s*(.+)$/$2/i ) {
						$res = $1;
						$res =~ s/^\s*(.*?)\s*$/$1/;
						@re = split( /\s+/, $res );
						$reCount = $reCount + @re;
						if ( $reCount == 1 ) {
							$subject = " Re: $subject";
						} elsif ( $reCount > 1 ) {
							$subject = " Re[$reCount]: $subject";
						}
					}
				
					$subject = jcode($subject)->mime_encode;
					$Envelope{'h:Subject:'} = $subject ;
				};
				EOS;
		$i++;	// 3. --------------------------------------------------------------------------------------------------
			$this->insertData[ $i ][ 'id' ] = 'to ensure the DKIM';
			$this->insertData[ $i ][ 'exists_check_key' ] = '{^# refer to https://mekiku.com}';
			$this->insertData[ $i ][ 'insert_point_key' ] = '/^# YOU CAN EDIT MANUALLY AFTER HERE\./';
			$this->insertData[ $i ][ 'insert_data' ] = <<<'EOS'
				# refer to https://mekiku.com/view.php?a=89
				# Changed reply-to:Mailing list addr,  From : Display Name (sender mail addr) <Mailing list addr>
				# to ensure the DKIM domain matches the mailing list domain
				
				$USE_ORIGINAL_MESSAGE_ID = 0;
				$SKIP_FIELDS = "Received|Return-Receipt-To|DKIM-Signature|X-Google-DKIM-Signature";
				$SMTP_OPEN_HOOK = q%
				$Envelope{'fh:reply-to:'} = $MAIL_LIST;
				$header_from = $Envelope{'h:from:'};
				$header_from =~ s/"//g;
				$header_from =~ s/</\(/g;
				$header_from =~ s/>/\)/g;
				$header_from =~ s/^\s+//;
				$header_from =~ s/\s+$//;
				$Envelope{'fh:from:'} = "\"" . $header_from . "\" <" . $MAIL_LIST . ">";
				%;
				EOS;
			// end -------------------------------------------------------------------------------------------------
	} // __construct

	//
	// FMLパス初期化
	//
	public function setFmlPath( $path ) {
		$this->fmlPath = $path;
	}

	//
	// カスタマイズが存在するか（アカウント単位）
	//
	public function checkCustomize( $account ) {
		$targetPath = $this->fmlPath . '/' . $account;
		$this->configArray = file( "{$targetPath}/config.ph", FILE_IGNORE_NEW_LINES );
		$existsCount = 0;
		$i = 0;
		foreach ( $this->insertData as $data ) {
			if ( $this->existsCheck( $data[ 'exists_check_key' ] ) ) {
				$existsCount++;
			}
			$i++;
		}
		return $existsCount;
	}

	//
	// 設置
	//
	public function setCustomize() {
		$this->resetCustomize();
		if ( $dir = opendir( $this->fmlPath ) ) {
			$mlCount = 0;
			while ( ( $file = readdir( $dir ) ) !== false ) {
				if ( $file != '.' && $file != '..' && $file != 'etc' && is_dir( $targetPath = "{$this->fmlPath}/{$file}" ) ) {
					$mlCount++;
					$this->setupParams( $targetPath );
				}
			}
		} else {
			return false;
		}
		return true;
	}

	//
	// 解除
	//
	public function resetCustomize() {
		if ( $dir = opendir( $this->fmlPath ) ) {
			$mlCount = 0;
			while ( ( $file = readdir( $dir ) ) !== false ) {
				if ( $file != '.' && $file != '..' && $file != 'etc' && is_dir( $targetPath = "{$this->fmlPath}/{$file}" ) ) {
					$mlCount++;
					$this->resetParams( $targetPath );
				}
			}
		} else {
			return false;
		}
		return true;
	}

	//
	// カスタマイズ設定が存在するか
	//
	protected function existsCheck( $existsCheckKey ) {
		foreach ( $this->configArray as $line ) {
			if ( preg_match( $existsCheckKey, $line ) ) {
				return true;
			}
		}
		return false;
	}

	//
	// 挿入ポイントの検索
	//
	protected function searchInsertPoint( $pointCheckKey ) {
		$i = 0;
		foreach ( $this->configArray as $line ) {
			if ( preg_match( $pointCheckKey, $line ) ) {
				return $i;
			}
			$i++;
		}
		return -1;
	}

	//
	// カスタマイズ設定を実行する
	//
	protected function setupParams( $targetPath ) {
		$this->configArray = file( "{$targetPath}/config.ph", FILE_IGNORE_NEW_LINES );
		$insertPoints = array();
		$i = 0;
		foreach ( $this->insertData as $data ) {
			if ( !$this->existsCheck( $data[ 'exists_check_key' ] ) ) {
				$insertPoint = $this->searchInsertPoint( $data[ 'insert_point_key' ] );
				if ( $insertPoint > 0 ) {
					$insertPoints[ $i ][ 'insert_point' ] = $insertPoint;
					$insertPoints[ $i ][ 'insert_data' ] = $data[ 'insert_data' ];
					$i++;
				}
			}
		}
		if ( $i > 0 ) {
			$outputArray = array();
			$i = 0;
			foreach ( $this->configArray as $line ) {
				$outputArray[] = $line;
				foreach ( $insertPoints as $insertPoint ) {
					if ( $i == $insertPoint[ 'insert_point' ] ) {
						$insertDataArray = explode( "\n", $insertPoint[ 'insert_data' ] );
						$outputArray[] = $this->customBlockBegin;
						foreach ( $insertDataArray as $data ) {
							$outputArray[] = $data;
						}
						$outputArray[] = $this->customBlockEnd;
					}
				}
				$i++;
			}
			file_put_contents( "{$targetPath}/bak.config.ph", implode( "\n", $this->configArray ) . "\n" );	// Backup to bak.config.ph
			file_put_contents( "{$targetPath}/config.ph", implode( "\n", $outputArray ) . "\n" );
		}
	}

	//
	// カスタマイズ設定を解除する
	//
	protected function resetParams( $targetPath ) {
		$this->configArray = file( "{$targetPath}/config.ph", FILE_IGNORE_NEW_LINES );
		$outputArray = array();
		$isOpen = false;
		$lastIndex = count( $this->configArray );
		$i = 0;
		while ( $i < $lastIndex ) {
			$line = $this->configArray[ $i ];
			if ( $line !== $this->customBlockBegin ) {
				// 管理外の &DEFINE_FIELD_FORCED( 'Reply-To', $MAIL_LIST ); を強制削除する
				if ( preg_match( '/^\s*\&DEFINE_FIELD_FORCED\s*\(\s*.Reply-To.\s*,\s*\$MAIL_LIST\s*\)/i', $line ) ) {
					$outputArray[] = "\n";
				} else {
					$outputArray[] = $line;
				}
			} else {
				$isOpen = true;
				while ( $i < $lastIndex ) {
					$i++;
					$line = $this->configArray[ $i ];
					if ( $line == $this->customBlockBegin ) {
						return false;
					}
					if ( $line == $this->customBlockEnd ) {
						$isOpen = false;
						break;
					}
				}
			}
			$i++;
		}
		if ( $isOpen ) {
		} else {
			file_put_contents( "{$targetPath}/bak.config.ph", implode( "\n", $this->configArray ) . "\n" );
			file_put_contents( "{$targetPath}/config.ph", implode( "\n", $outputArray ) . "\n" );
		}
	}

} // class customizeFml

?>