<html lang="ja">
<head>
<?php include( 'common.php' ); include( 'mail_handler.php' ); include( 'customize_fml.php' ); ?>
<meta charset="utf-8">
<link rel="stylesheet" href="<?php addUpdateQuery( "custom.css" ); ?>" />
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
<script src="jquery-3.7.1.min.js"></script>
<script src="<?php addUpdateQuery( "custom.js" ); ?>"></script>
</head>
<?php
/* =====================================================
	基本情報を整える
 ===================================================== */
$simultaneousMailingStatus = getPropertyBool( "show_option01" );
$allowSSO = getPropertyBool( "allow_sso_signin" );

/* =====================================================
	インストーラが残っていたら消去する
 ===================================================== */
if ( getPropertyBool( "not_initialized" ) ) {
	header( "location:{$scriptHomeUri}/install.php" );
	exit;
}
if ( file_exists( "./install.php" ) ) {
	unlink( "./install.php" );
}

/* =====================================================
	セッション管理
 ===================================================== */
if ( !is_null( getProperty( "session_control" ) ) && !getPropertyBool( "session_control" ) ) {	// キーがない場合にもセッションが働くように is_null で確認する
	integrityChecking();
	header( "location:{$scriptHomeUri}/members.php" );
} else {
	if ( $allowSSO ) {
		if ( $_POST[ 'func' ] == "SSO_REQUEST" ) {
			if ( validateToken( $_POST[ 'token' ] ) ) {
				session_name( SESSION_ID );
				session_start();
				session_regenerate_id( true );
				$_SESSION[ 'signin_id' ] = $_POST[ 'signin_id' ];
				$_SESSION[ 'signin_user' ] = $_POST[ 'signin_user' ];
				$_SESSION[ 'root' ] = ( $_POST[ 'author' ] == "1" ) ? true : false;
				if ( $_POST[ 'home' ] ) $_SESSION[ 'home' ] = $_POST[ 'home' ];
				integrityChecking();
				loggingSignin( $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
				header( "location:{$scriptHomeUri}/members.php" );
			} else {
				echo <<<EOT
				<body>
				<h1>メールアドレス登録管理コンソール</h1>
				<p>有効なトークンが見つかりませんでした。</p>
				<p><a class="link_button" href="{$_POST[ 'home' ]}">会員専用サイトに戻る</a></p>
				</body>
				</html>
				EOT;
			}
			exit;
		} else {
			session_name( SESSION_ID );
			session_start();
			if ( ! $_SESSION[ 'signin_id' ] ) die( file_get_contents( "forbidden.txt" ) );
			loggingSignout( $_SESSION[ 'signin_id' ], $_SESSION[ 'signin_user' ] );
			$homeUri = $_SESSION[ 'home' ];
			$_SESSION = array();
			if ( isset( $_COOKIE[ SESSION_ID ] ) ) {
				setcookie( SESSION_ID, '', time() - 1800, '/' );
			}
			session_destroy();
			if ( $homeUri ) {
				header( "location:{$homeUri}" );
			}
		}
	}
	$signinMessage = "";
	switch ( $_POST[ 'func' ] ) {
		case 'self_signin':
			if ( password_verify( $_POST[ 'pw' ], getPassword( $_POST[ 'id' ] ) ) ) {
				session_name( SESSION_ID );
				session_start();
				session_regenerate_id( true );
				$_SESSION[ 'signin_id' ] = $_POST[ 'id' ];
				$signinUserName = getUserName( $_SESSION[ 'signin_id' ] );
				if ( $signinUserName ) $_SESSION[ 'signin_user' ] = $signinUserName;
				$_SESSION[ 'root' ] = isRoot( $_POST[ 'id' ] );
				integrityChecking();
				loggingSignin( $_SESSION[ 'signin_id' ], $_SESSION[ 'signin_user' ] );
				header( "location:{$scriptHomeUri}/members.php" );
				exit;
			}
			$signinMessage = "IDまたはパスワードが一致しません。";
			break;
		case 'self_register_admin':
		// サインアウト処理
			$signinMessage = "管理者を登録するところです。";
			break;
		default:
			session_name( SESSION_ID );
			session_start();
			if ( isset( $_SESSION[ 'signin_id' ] ) ) {
				loggingSignout( $_SESSION[ 'signin_id' ], $_SESSION[ 'signin_user' ] );
			}
			$_SESSION = array();
			if ( isset( $_COOKIE[ SESSION_ID ] ) ) {
				setcookie( SESSION_ID, '', time() - 1800, '/' );
			}
			session_destroy();
			$signinMessage = "サインインしてください";
	} // switch
	echo <<<EOT
	<body>
	<h1>{$mainTitle}</h1>
	<h3>{$signinMessage}</h3>
	<div>
		<div id="status_area01"></div>
		<div class="outer_block">
			<form id="siginin" action="" method="POST">
			<span>ID</span><input name="id" type="text" /><br />
			<div class="input-wrap">
				<span>PW</span><input name="pw" type="password" />
				<i class="toggle-pass fa fa-eye-slash"></i>
			</div>
			<span></span><input type="submit" />
			<input name="func" type="hidden" value="self_signin" />
			</form>
		</div>
	</div>
	</body>
	</html>
	EOT;
	exit;
}

//
// サインインのログ
//
function loggingSignin( $signinId, $signinUser ) {
	logger( 'SIGNIN', $signinId, $signinUser );
}
function loggingSignout( $signinId, $signinUser ) {
	logger( 'SIGNOUT', $signinId, $signinUser );
}
function logger( $func, $signinId, $signinUser ) {
	try {
		$pdo = new PDO( MAINDB_DSN );
		$unixTime = time();
		$sql = "INSERT INTO log ( action, account, account_owner, data, signin_id, signin_user, time ) VALUES ( :action, :account, :account_owner, '', :signin_id, :signin_user, :time );";
		$stmt = $pdo->prepare( $sql );
		$stmt->bindParam( ":action", $func, PDO::PARAM_STR );
		$stmt->bindParam( ":account", $signinId, PDO::PARAM_STR );
		$stmt->bindParam( ":account_owner", $signinUser, PDO::PARAM_STR );
		$stmt->bindParam( ":signin_id", $signinId, PDO::PARAM_STR );
		$stmt->bindParam( ":signin_user", $signinUser, PDO::PARAM_STR );
		$stmt->bindParam( ":time", $unixTime, PDO::PARAM_INT );
		$stmt->execute();
		$pdo = null;
	} catch ( Exception $e ) {
		return $e->getMessage();
	}
}

//
// サーバー情報をDBにバックアップ
// 利用していないが、非常時に役立つかもしれない
//
function integrityChecking() {
	global $userRoot;
	global $fmlPath;
	global $mailPath;

	$mails = new Mails( MAINDB_DSN );
	$mails->setFmlPath( $fmlPath );
	$mails->setMailPath( $mailPath );

	$sessionId = time();

	try {
		$pdo = new PDO( MAINDB_DSN );
		$pdo->query( "DELETE FROM email_links WHERE session > 0;" );
		//
		// FML
		//
		if ( is_dir( $fmlPath ) ) {
			if ( $dh = opendir( $fmlPath ) ) {
				while ( ( $mailbox = readdir( $dh ) ) !== false ) {
					//
					// FMLメールボックスを巡回する
					//
					$mlDirPath = $fmlPath . '/' . $mailbox;
					$membersPath = $mlDirPath . "/members";
					if ( $mailbox != "." and $mailbox != ".." and is_dir( $mlDirPath ) and file_exists( $membersPath ) ) {
						$members = $mails->getFmlUserSorted( $membersPath );
						$sql = "";
						$delimiter = "";
						foreach ( $members as $member ) {
							$sql .= "{$delimiter} ( {$member[ 'id' ]}, '{$member[ 'email' ]}', '{$mailbox}', 'ml', {$sessionId} )";
							$delimiter = ",\n";
						}
						if ( $sql !== "" ) {
							$sql = "INSERT INTO email_links ( email_id, email, account, system, session ) VALUES\n" . $sql . ";";
							$pdo->query( $sql );
						}
					}
				}
				closedir( $dh );
			}
		} // FML

		//
		// CC
		//
		if ( is_dir( $mailPath ) ) {
			if ( $dh = opendir( $mailPath ) ) {
				while ( false !== ( $mailboxList[] = readdir( $dh ) ) );
				closedir( $dh );
				sort( $mailboxList );
				foreach ( $mailboxList as $mailbox ) {
					if ( $mailbox == false || $mailbox == "" || $mailbox[ 0 ] == "." || $mailbox[ 0 ] == "!" ) continue;
					$mlDirPath = $mailPath . '/' . $mailbox;
					$membersPath = $mlDirPath;
					if ( !is_dir( $mlDirPath ) || file_exists( "$mlDirPath/.is_ml_address" ) ) continue;
					$members = $mails->getCcUsersSorted( $membersPath );
					$sql = "";
					$delimiter = "";
					foreach ( $members as $member ) {
						$sql .= "{$delimiter} ( {$member[ 'id' ]}, '{$member[ 'email' ]}', '{$mailbox}', 'cc', {$sessionId} )";
						$delimiter = ",\n";
					}
					if ( $sql !== "" ) {
						$sql = "INSERT INTO email_links ( email_id, email, account, system, session ) VALUES\n" . $sql . ";";
						$pdo->query( $sql );
					}
				}
			}
		}

	} catch ( Exception $e ) {
		echo $e->getMessage();
	}
} // integrityChecking

?>
