<html lang="ja">
<head>
<?php include( 'common.php' ); include( 'mail_handler.php' ); ?>
<meta charset="utf-8">
<link rel="stylesheet" href="<?php addUpdateQuery( "custom.css" ); ?>" />
<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.15.4/css/all.css">
<script src="jquery-3.7.1.min.js"></script>
<script src="<?php addUpdateQuery( "custom.js" ); ?>"></script>
</head>
<?php

/* =====================================================
	アカウントのバックアップ
 ===================================================== */
$backupStatus = "<div>\n<div class=\"outer_block\">\n";
eraseBackup();
if ( backupAllCcs() ) {
	$backupStatus .= "<p>各メールアカウントの転送先(CC)をバックアップしました。</p>\n";
} else {
	$backupStatus .= "<p>各メールアカウントの転送先(CC)をバックアップしました。（一部失敗しました。）</p>\n";
}
if ( backupAllFmls() ) {
	$backupStatus .= "<p>各メーリングリストの配信先をバックアップしました。</p>\n";
} else {
	$backupStatus .= "<p>各メーリングリストの配信先をバックアップしました。（一部失敗しました。）</p>\n";
}
deleteProperty( 'not_initialized' );		// 未初期化フラグを削除する
$httpHost = $_SERVER[ "HTTP_HOST" ];
setProperty( 'allowed_referer1', $httpHost );
$backupStatus .= "<p>自己ドメイン'{$httpHost}'のアクセス許可をプロパティ(allowed_referer1)に設定しました。</p>\n";
$backupStatus .= "</div>\n</div>\n";

$registerForm = <<<EOT
	<div>
		<div id="status_area01"></div>
		<div class="outer_block">
			<form id="siginin" action="" method="POST">
			<span>ID</span><input name="id" type="text" /><br />
			<span>PW</span><input name="pw" type="text" /><br /><br />
			<span></span><input type="submit" />
			<input name="func" type="hidden" value="self_register_root" />
			</form>
		</div>
	</div>
	EOT;
$initMassage = "【初期設定】管理者を登録します。登録したIDとパスワードは厳重に管理してください。";
$signinMessage = "";
switch ( $_POST[ 'func' ] ) {
	case 'self_signin':
		if ( $_POST[ 'pw' ] && $_POST[ 'pw' ] == getPassword( $_POST[ 'id' ] ) ) {
			session_start();
			session_regenerate_id( true );
			$_SESSION[ 'user_id' ] = $_POST[ 'id' ];
			echo "<body></body></html>";
			header( "location:{$scriptHomeUri}/members.php" );
			exit;
		}
		$signinMessage = "IDまたはパスワードが一致しません。";
		break;
	case 'self_register_root':
		if ( $_POST[ 'id' ] && $_POST[ 'pw' ] ) {
			$userId = $_POST[ 'id' ];
			$password = $_POST[ 'pw' ];
			$validateId = false;
			$validatePw = false;
			$signinMessage = "";
			if ( preg_match( "/^[a-zA-Z0-9\-\_]+$/", $userId, $matches ) ) {
				$validateId = true;
			} else {
				$signinMessage = "IDに不正な文字が使われています。\n";
			}
			if ( preg_match( "/^[a-zA-Z0-9\-\_\#\%\$]+$/", $password, $matches ) ) {
				$validatePw = true;
			} else {
				$signinMessage .= "パスワードに不正な文字が使われています。\n";
			}
			$signinMessage .= $initMassage;
			if ( $validateId && $validatePw ) {
				if ( appendUser( $userId, $password, true, "" ) ) {
					$signinMessage = "管理者を登録しました。";
					$registerForm = <<<EOT
						<p>install.phpはログイン時に削除されます。</p>
						<p>install.phpを残しておくとセキュリティ上危険です。ただちにログインして設定を行ってください。</p>
						<a class="link_button" href="{$scriptHomeUri}/">ログイン画面へ</a>
					EOT;
				} else {
					$signinMessage = "そのIDは使われています。<br />\n" . $initMassage;
				}
			}
		} else {
			$signinMessage = "IDまたはパスワードが空欄です。<br />\n" . $initMassage;
		}
		echo <<<EOT
		<body>
		<h1>メールアドレス登録管理コンソール</h1>
		{$backupStatus}
		<p>{$signinMessage}</p>
		{$registerForm}
		</body>
		</html>
		EOT;
		eixt;
	default:
		$signinMessage = $initMassage;
		echo <<<EOT
		<body>
		<h1>メールアドレス登録管理コンソール</h1>
		{$backupStatus}
		<p>{$signinMessage}</p>
		{$registerForm}
		</body>
		</html>
		EOT;
		exit;
} // switch
echo <<<EOT
<body>
<h1>メールアドレス登録管理コンソール</h1>
{$backupStatus}
<p>{$signinMessage}</p>
<div>
	<div id="status_area01"></div>
	<div class="outer_block">
		<form id="siginin" action="" method="POST">
		<span>ID</span><input name="id" type="text" /><br />
		<div class="input-wrap">
			<span>PW</span><input name="pw" type="password" />
			<i class="toggle-pass fa fa-eye-slash"></i>
		</div>
		<span></span><input type="submit" />
		<input name="func" type="hidden" value="self_signin" />
		</form>
	</div>
</div>
</body>
</html>
EOT;
exit;

/* =====================================================
	バックアップ・ドライバ群
 ===================================================== */

function eraseBackup() {
	try {
		$pdo = new PDO( MAINDB_DSN );
		$sql = "DELETE FROM email_links;";
		$stmt = $pdo->query( $sql );
		$pdo = null;
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
}

function backupAllCcs() {
	global $mailPath;
	if ( !is_dir( $mailPath ) ) {
		return false;
	}
	if ( $dh = opendir( $mailPath ) ) {
		$result = true;
		while ( false !== ( $mailboxList[] = readdir( $dh ) ) );
		closedir( $dh );
//		sort( $mailboxList );
		foreach ( $mailboxList as $mailbox ) {
			if ( $mailbox[ 0 ] == "!" ) continue;
			$mlDirPath = $mailPath . '/' . $mailbox;
			if ( $mailbox != "" and $mailbox != "." and $mailbox != ".." and is_dir( $mlDirPath ) and ( count( glob( "$mlDirPath/.is_ml_address" ) ) == 0 ) ) {
				if ( !backupCc( $mlDirPath, $mailbox ) ) {
					$result = false;
				}
			}
		}
	} else {
		return false;
	}
	return $result;
}

function backupCc( $path, $account ) {
	$path = ( substr( $string, -1 ) == '/' ) ? $path . '.mailfilter' : $path . '/.mailfilter';
	if ( !file_exists( $path ) ) {
		return true;		// .mailfilterが存在しなくてもエラーではない
	}
	$ccs = array();
	$members = file( $path );
	if ( count( $members ) > 0 ) {
		foreach ( $members as $member ) {
			if ( preg_match( "/^cc\s*\"!([^\"]+)\s*\"$/", $member, $results ) == 1 ) {
				$ccs[] = $results[ 1 ];
			}
			elseif ( preg_match( "/^cc\s*\"\|.+change_from\.pl\s+([^\"]+)\s*\"$/", $member, $results ) == 1 ) {
				$ccs[] = $results[ 1 ];
			}
		}
	}
	try {
		$pdo = new PDO( MAINDB_DSN );
		$sql = "INSERT INTO email_links ( email, account, system, session ) VALUES ( :email, '{$account}', 'cc', 0 );";
		$stmt = $pdo->prepare( $sql );
		foreach ( $ccs as $email ) {
			$stmt->bindValue( ":email", $email, PDO::PARAM_STR );
			$stmt->execute();
		}
		$sql = "UPDATE email_links SET email_id=emails.id FROM emails WHERE email_links.email=emails.email;";
		$stmt = $pdo->query( $sql );
		$pdo = null;
		return true;
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
		return false;
	}
}

function backupAllFmls() {
	global $fmlPath;
	if ( !is_dir( $fmlPath ) ) {
		return false;
	}
	$result = true;
	if ( $dh = opendir( $fmlPath ) ) {
		while ( ( $mailbox = readdir( $dh ) ) !== false ) {
			$mlDirPath = $fmlPath . '/' . $mailbox;
			$membersPath = $mlDirPath . "/members";
			if ( $mailbox != "." and $mailbox != ".." and is_dir( $mlDirPath ) and file_exists( $membersPath ) ) {
				if ( !backupFml( $membersPath, $mailbox ) ) {
					$result = false;
				}
			}
		}
		closedir( $dh );
	}
	return $result;
}

function backupFml( $path, $account ) {
	$members = file( $path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
	$ccs = array();
	foreach ( $members as $member ) {
		if ( preg_match( "/^#/", $member ) == 0 ) {
			$ccs[] = $member;
		}
	}
	try {
		$pdo = new PDO( MAINDB_DSN );
		$sql = "INSERT INTO email_links ( email, account, system, session ) VALUES ( :email, '{$account}', 'ml', 0 );";
		$stmt = $pdo->prepare( $sql );
		foreach ( $ccs as $email ) {
			$stmt->bindValue( ":email", $email, PDO::PARAM_STR );
			$stmt->execute();
		}
		$sql = "UPDATE email_links SET email_id=emails.id FROM emails WHERE email_links.email=emails.email;";
		$stmt = $pdo->query( $sql );
		$pdo = null;
		return true;
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
		return false;
	}
}

?>
