<?php
if ( array_shift( get_included_files() ) === __FILE__ ) {
	die( file_get_contents( "forbidden.txt" ) );
}
/* =====================================================

■ さくらインターネットメールサーバー管理情報

★FMLの使うメールアカウントもここに設置されているので注意
/home/domain/MailBox/account/.is_ml_address	<== このファイルがあればML用アカウント
/home/domain/MailBox/account/postmaster		<== 排除

/home/domain/MailBox/account/.mailfilter
	cc "!abc@gmail.com"
	cc "!def@gmail.com"
	cc "!ghi@gmail.com"

/home/domain/fml/spool/ml/account/actives
/home/domain/fml/spool/ml/account/members

 ======================================================= */

class Mails {
	protected $fmlPath = "";
	protected $mailPath = "";
	protected $dbHost = "";
	protected $ccAccounts = array();
	protected $fmlAccounts = array();
	protected $defaultModEnvelope = false;
	protected $repairModEnvelope =false;
	protected $pdo = null;
	protected $customFml;

	public function __construct( $dbHost ) {
		$this->dbHost = $dbHost;
		$this->pdo = new PDO( $dbHost );
		$this->$customFml = new customizeFml();
	}
	public function __destruct() {
		$this->pdo = null;
	}
	public function setFmlPath( $path ) {
		$this->fmlPath = $path;
		$this->$customFml->setFmlPath( $path );
	}
	public function getFmlPath() {
		return $this->fmlPath;
	}
	public function setMailPath( $path ) {
		$this->mailPath = $path;
	}
	public function getMailPath() {
		return $this->mailPath;
	}
	public function getDbHost() {
		return $this->dbHost;
	}
	public function setDefaultModEnvelope( $switch ) {
		$this->defaultModEnvelope = $switch;
	}
	public function getCcAccountList() {
		if ( count( $this->ccAccounts ) == 0 ) {
			$this->searchAddressAllCc( "" );
		}
		return $this->ccAccounts;
	}
	public function getFmlAccountList() {
		if ( count( $this->fmlAccounts ) == 0 ) {
			$this->searchAddressAllFml( "" );
		}
		return $this->fmlAccounts;
	}
	public function repairModEnvelopeAll() {
		$this->repairModEnvelope = true;
		$this->searchAddressAllCc( "" );
		$this->repairModEnvelope = false;
	}

	public function getFmlUserSorted( $path ) {
		$result = array();
		$mails = $this->getFmlUsers( $path );
		if ( count( $mails ) == 0 ) return $result;
		foreach ( $mails as $value ) {
			$sortKeys[] = is_null( $value[ 'reading' ] ) ? "ん" : $value[ 'reading' ];
		}
		asort( $sortKeys );
		foreach ( $sortKeys as $key => $value ) {
			$result[] = $mails[ $key ];
		}
		return $result;
	}

	public function getFmlUsers( $path ) {
		try {
			$stmt = $this->pdo->prepare( "SELECT user_hub.id, name, reading FROM user_hub INNER JOIN emails ON user_hub.id=emails.user_id WHERE email=?" );
			$result = Array();
			$members = file( $path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
			$i = 0;
			foreach ( $members as $member ) {
				if ( preg_match( "/^#/", $member ) == 0 ) {
					$stmt->execute( Array( $member ) );
					$result[ $i ] = $stmt->fetch();
					if ( !isset( $result[ $i ][ 'name' ] ) ) {
						$result[ $i ][ 'id' ] = 0;
						$result[ $i ][ 'name' ] = "";
						$result[ $i ][ 'reading' ] = "";
					}
					$result[ $i ][ 'email' ] = $member;
					$i++;
				}
			}
			return $result;
		} catch ( Exception $e ) {
			echo $e->getMessage() . PHP_EOL;
		}
	}

	public function getCcUsersSorted( $path ) {
		$result = array();
		$mails = $this->getCcUsers( $path );
		if ( count( $mails ) == 0 ) return $result;
		foreach ( $mails as $value ) {
			$sortKeys[] = is_null( $value[ 'reading' ] ) ? "ん" : $value[ 'reading' ];
		}
		asort( $sortKeys );
		foreach ( $sortKeys as $key => $value ) {
			$result[] = $mails[ $key ];
		}
		return $result;
	}

	public function getCcUsers( $path ) {
		$path = ( substr( $string, -1 ) == '/' ) ? $path . '.mailfilter' : $path . '/.mailfilter';
		if ( !file_exists( $path ) ) {
			return array();
		}
		try {
			$result = array();
			$outBuff = array();
			$members = file( $path );
			if ( count( $members ) > 0 ) {
				$sql = "SELECT user_hub.id, name, reading FROM user_hub INNER JOIN emails ON user_hub.id=emails.user_id WHERE email=?;";
				$stmt = $this->pdo->prepare( $sql );
				$i = 0;
				foreach ( $members as $member ) {
					if ( preg_match( "/^cc\s*\"!([^\"]+)\s*\"$/", $member, $results ) == 1 ) {
						$stmt->execute( Array( $results[ 1 ] ) );
						$result[ $i ] = $stmt->fetch();
						if ( !isset( $result[ $i ][ 'name' ] ) ) {
							$result[ $i ][ 'id' ] = 0;
							$result[ $i ][ 'name' ] = "";
							$result[ $i ][ 'reading' ] = "";
						}
						$result[ $i ][ 'email' ] = $results[ 1 ];
						$result[ $i ][ 'mod_envelope' ] = False;
						if ( $this->repairModEnvelope ) {
							if ( $this->defaultModEnvelope ) {
								$outBuff[] = "cc \"|perl \$HOME/../../misc/custom_script/change_from.pl {$results[ 1 ]}\"\n";
							} else {
								$outBuff[] = $member;
							}
						}
						$i++;
					}
					elseif ( preg_match( "/^cc\s*\"\|.+change_from\.pl\s+([^\"]+)\s*\"$/", $member, $results ) == 1 ) {
						$stmt->execute( Array( $results[ 1 ] ) );
						$result[ $i ] = $stmt->fetch();
						if ( !isset( $result[ $i ][ 'name' ] ) ) {
							$result[ $i ][ 'name' ] = "";
							$result[ $i ][ 'reading' ] = "";
						}
						$result[ $i ][ 'email' ] = $results[ 1 ];
						$result[ $i ][ 'mod_envelope' ] = True;
						if ( $this->repairModEnvelope ) {
							if ( $this->defaultModEnvelope ) {
								$outBuff[] = $member;
							} else {
								$outBuff[] = "cc \"!{$results[ 1 ]}\"\n";
							}
						}
						$i++;
					}
					elseif ( $this->repairModEnvelope ) {
						$outBuff[] = $member;
					}
				}
			}
			if ( $this->repairModEnvelope ) {
				file_put_contents( $path, implode( "", $outBuff ) );
			}
			return $result;
		} catch ( Exception $e ) {
			echo $e->getMessage() . PHP_EOL;
		}
	}

	public function searchAddressFml( $account, $email ) {
		$path = $this->fmlPath . "/" . $account . "/members";
		$members = $this->getFmlUsers( $path );
		foreach ( $members as $member ) {
			if ( strcasecmp( $email, $member[ 'email' ] ) == 0 ) {
				return True;
			}
		}
		return False;
	}

	public function searchAddressAllFml( $email ) {
		$result = array();
		if ( !is_dir( $this->fmlPath ) ) {
			return $result;
		}
		if ( $dh = opendir( $this->fmlPath ) ) {
			$makeFmlList = false;
			if ( count( $this->fmlAccounts ) == 0 ) {
				$makeFmlList = true;	// MLアカウントリストをキャッシュする
			}
			while ( ( $mailbox = readdir( $dh ) ) !== false ) {
				$mlDirPath = $this->fmlPath . '/' . $mailbox;
				$membersPath = $mlDirPath . "/members";
				if ( $mailbox != "." and $mailbox != ".." and is_dir( $mlDirPath ) and file_exists( $membersPath ) ) {
					if ( $makeFmlList ) {
						$commentPath = $mlDirPath . "/.comment";
						if ( file_exists( $commentPath ) ) {
							$comment = file_get_contents( $commentPath );
						} else {
							$comment = "";
						}
						$this->fmlAccounts[] = array( 'account' => $mailbox, 'comment' => $comment );
					}
					if ( $this->searchAddressFml( $mailbox, $email ) ) {
						$result[] = $mailbox;
					}
				}
			}
			closedir( $dh );
		}
		return $result;
	}

	//
	// FML : メールアドレス削除（DBにも反映）
	//
	public function deleteFml( $account, $email ) {
		$path = $this->fmlPath . "/" . $account;
		if ( !file_exists( $path . "/members" ) ) {
			return "PATH_NOT_FOUND_ERROR " . $path;
		}
		$members = file( $path . "/members" );
		$outBuff = array();
		$match = false;
		foreach ( $members as $member ) {
			if ( substr( trim( $member ), 0, 1 ) == "#" ) continue;
			if ( strcasecmp( $email, trim( $member ) ) == 0 ) {		// 一致する場合はリストから省く
				$match = true;
			} else {
				$outBuff[] = $member;
			}
		}
		if ( $match ) {
			file_put_contents( $path . "/members", implode( "", $outBuff ) );
			file_put_contents( $path . "/actives", implode( "", $outBuff ) );
		}
		try {
			$sql = "DELETE FROM email_links WHERE email=:email AND account=:account AND system='ml' AND session=0;";
			$stmt = $this->pdo->prepare( $sql );
			$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
			$stmt->bindParam( ":account", $account, PDO::PARAM_STR );
			$stmt->execute();
			$sql = <<<ESQL
				DELETE FROM emails WHERE
					id IN (
						SELECT emails.id
						FROM emails OUTER LEFT JOIN email_links ON emails.id=email_links.email_id
						WHERE emails.email=:email AND email_links.id IS NULL
					);
				ESQL;
			$stmt = $this->pdo->prepare( $sql );
			$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
			$stmt->execute();
		} catch ( Exception $e ) {
			return $e->getMessage();
		}
		return "DELETED";
	}

	//
	// FML : メールアドレスを追加する
	//
	public function appendFml( $account, $email ) {
		$path = $this->fmlPath . "/" . $account;
		if ( !file_exists( $path . "/members" ) ) {
			return "PATH_NOT_FOUND_ERROR " . $path;
		}
		$members = file( $path . "/members" );
		$outBuff = array();
		$match = false;
		foreach ( $members as $member ) {
			if ( substr( trim( $member ), 0, 1 ) == "#" ) continue;
			if ( strcasecmp( $email, trim( $member ) ) == 0 ) $match = true;
			$outBuff[] = $member;
		}
		if ( !$match ) {
			$outBuff[] = $email . "\n";
		}
		try {
			$sql = "SELECT count(*) FROM emails WHERE email=:email;";
			$stmt = $this->pdo->prepare( $sql );
			$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
			$stmt->execute();
			if ( (int)$stmt->fetchColumn() == 0 ) {
				$sql = "INSERT INTO emails ( email ) VALUES ( :email );";
				$stmt = $this->pdo->prepare( $sql );
				$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
				$stmt->execute();
			}
			$sql = "SELECT count(*) FROM email_links WHERE email=:email AND account=:account AND system='ml' AND session=0;";
			$stmt = $this->pdo->prepare( $sql );
			$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
			$stmt->bindParam( ":account", $account, PDO::PARAM_STR );
			$stmt->execute();
			if ( (int)$stmt->fetchColumn() == 0 ) {
				$sql = "INSERT INTO email_links ( email, account, system, session ) VALUES ( :email, :account, 'ml', 0 );";
				$stmt = $this->pdo->prepare( $sql );
				$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
				$stmt->bindParam( ":account", $account, PDO::PARAM_STR );
				$stmt->execute();
			}
			$sql = "UPDATE email_links SET email_id=emails.id FROM emails WHERE email_links.email=emails.email AND email_links.session=0;";
			$stmt = $this->pdo->query( $sql );
		} catch ( Exception $e ) {
			return $e->getMessage();
		}
		file_put_contents( $path . "/members", implode( "", $outBuff ) );
		file_put_contents( $path . "/actives", implode( "", $outBuff ) );
		return "APPENDED";
	}

	public function searchAddressCc( $account, $email ) {
		$path = $this->mailPath . "/" . $account;
		$members = $this->getCcUsers( $path );
		foreach ( $members as $member ) {
			if ( strcasecmp( $email, $member[ 'email' ] ) == 0 ) {
				return array( 'email' => $member[ 'email' ], 'mod_envelope' => $member[ 'mod_envelope' ] );
			}
		}
		return array();
	}

	public function searchAddressAllCc( $email ) {
		$result = array();
		if ( !is_dir( $this->mailPath ) ) {
			return $result;
		}
		if ( $dh = opendir( $this->mailPath ) ) {
			while ( false !== ( $mailboxList[] = readdir( $dh ) ) );
			closedir( $dh );
			sort( $mailboxList );
			$makeCcList = false;
			if ( count( $this->ccAccounts ) == 0 ) { $makeCcList = true; }	// CCアカウントリストをキャッシュする
			foreach ( $mailboxList as $mailbox ) {
				if ( $mailbox[ 0 ] == "!" ) continue;
				$mlDirPath = $this->mailPath . '/' . $mailbox;
				if ( $mailbox != "" and $mailbox != "." and $mailbox != ".." and is_dir( $mlDirPath ) and ( count( glob( "$mlDirPath/.is_ml_address" ) ) == 0 ) ) {
					if ( $makeCcList ) {
						$comment = file_get_contents( "$mlDirPath/.comment" );
						$this->ccAccounts[] = array( 'account' => $mailbox, 'comment' => $comment );
					}
					$cc = $this->searchAddressCc( $mailbox, $email );
					if ( count( $cc ) > 0 ) {
						$result[] = array( 'email' => $mailbox, 'mod_envelope' => $cc[ 'mod_envelope' ] );
					}
				}
			}
		}
		return $result;
	}

	//
	// email : MailBoxにアドレス追加（DBにも反映）
	//
	public function appendCc( $account, $email ) {
		$path = $this->mailPath . "/" . $account;
		if ( !file_exists( $path . "/.mailfilter" ) ) {
			return "PATH_NOT_FOUND_ERROR" . $path;
		}
		if ( file_exists( $path . "/.is_ml_address" ) ) {
			return "NOT_MAILBOX_ERROR";
		}
		$path .= "/.mailfilter";
		$members = file( $path );
		$outBuff = array();
		$match = false;
		// 空行を削除する（最終行のexitの検出のため、とくにファイルの終わりにある空行を消したい）
		foreach ( $members as $key => $member ) {
			if ( trim( $member ) == "" ) {
				unset( $members[ $key ] );
			}
		}
		//array_values( $members );
		// 最終行にexitがあれば取り除く（exitの前にCCを置くため）
		$lastExit = false;
		if ( strtolower( trim( $members[ array_key_last( $members ) ] ) ) == "exit" ) {
			$lastExit = true;
			unset( $members[ array_key_last( $members ) ] );
		}
		foreach ( $members as $member ) {
			if ( preg_match( "/^cc\s*\"\|.+change_from\.pl\s+([^\"]+)\s*\"$/", $member, $results ) == 1 || preg_match( "/^cc\s*\"!([^\"]+)\s*\"$/", $member, $results ) == 1 ) {
				if ( strcasecmp( $email, $results[ 1 ] ) == 0 ) {
					$match = true;
				} else {
					$outBuff[] = $member;
				}
			} else {
				$outBuff[] = $member;
			}
		}
		if ( !$match ) {
//			if ( $this->defaultModEnvelope ) {
//				$outBuff[] = "cc \"|perl \$HOME/../../misc/custom_script/change_from.pl {$email}\"\n";
//				$result = "APPENDED_MOD_ENVELOPE";
//			} else {
				$outBuff[] = "cc \"!{$email}\"\n";
//			}
			if ( $lastExit ) $outBuff[] = "exit\n";
			file_put_contents( $path, implode( "", $outBuff ) );
		}
		try {
			$sql = "SELECT count(*) FROM emails WHERE email=:email;";
			$stmt = $this->pdo->prepare( $sql );
			$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
			$stmt->execute();
			if ( (int)$stmt->fetchColumn() == 0 ) {
				$sql = "INSERT INTO emails ( email ) VALUES ( :email );";
				$stmt = $this->pdo->prepare( $sql );
				$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
				$stmt->execute();
			}
			$sql = "SELECT count(*) FROM email_links WHERE email=:email AND account=:account AND system='cc' AND session=0;";
			$stmt = $this->pdo->prepare( $sql );
			$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
			$stmt->bindParam( ":account", $account, PDO::PARAM_STR );
			$stmt->execute();
			if ( (int)$stmt->fetchColumn() == 0 ) {
				$sql = "INSERT INTO email_links ( email, account, system, session ) VALUES ( :email, :account, 'cc', 0 );";
				$stmt = $this->pdo->prepare( $sql );
				$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
				$stmt->bindParam( ":account", $account, PDO::PARAM_STR );
				$stmt->execute();
				$sql = "UPDATE email_links SET email_id=emails.id FROM emails WHERE email_links.email=emails.email AND email_links.session=0;";
				$stmt = $this->pdo->query( $sql );
			}
		} catch ( Exception $e ) {
			return $e->getMessage();
		}
		return "APPENDED";
	}

	//
	// email : メールアドレス削除＆DB登録解除
	//
	public function deleteCc( $account, $email ) {
		$path = $this->mailPath . "/" . $account;
		if ( !file_exists( $path . "/.mailfilter" ) ) {
			return "PATH_NOT_FOUND_ERROR" . $path;
		}
		if ( file_exists( $path . "/.is_ml_address" ) ) {
			return "NOT_MAILBOX_ERROR";
		}
		$path .= "/.mailfilter";
		$members = file( $path );
		$outBuff = array();
		// 空行を削除する（最終行のexitの検出のため、とくにファイルの終わりにある空行を消したい）
		foreach ( $members as $key => $member ) {
			if ( trim( $member ) == "" ) {
				unset( $members[ $key ] );
			}
		}
		//array_values( $members );
		// 最終行にexitがあれば取り除く（exitの前にCCを置くため）
		$lastExit = false;
		if ( strtolower( trim( $members[ array_key_last( $members ) ] ) ) == "exit" ) {
			$lastExit = true;
			unset( $members[ array_key_last( $members ) ] );
		}
		$match = false;
		foreach ( $members as $member ) {
//			if ( preg_match( "/^cc\s*\"\|.+change_from\.pl\s+([^\"]+)\s*\"$/", $member, $results ) == 1 || preg_match( "/^cc\s*\"!([^\"]+)\s*\"$/", $member, $results ) == 1 ) {
			if ( preg_match( "/^cc\s*\"!([^\"]+)\s*\"$/", $member, $results ) == 1 ) {
				if ( strcasecmp( $email, $results[ 1 ] ) == 0 ) {
					$match = true;
				} else {
					$outBuff[] = $member;
				}
			} else {
				$outBuff[] = $member;
			}
		}
		$result = "DELETED";
		if ( $match ) {
			if ( $lastExit ) $outBuff[] = "exit\n";
			file_put_contents( $path, implode( "", $outBuff ) );
		}
		try {
			$sql = "DELETE FROM email_links WHERE email=:email AND account=:account AND system='cc' AND session=0;";
			$stmt = $this->pdo->prepare( $sql );
			$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
			$stmt->bindParam( ":account", $account, PDO::PARAM_STR );
			$stmt->execute();
			$sql = <<<ESQL
				DELETE FROM emails WHERE
					id IN (
						SELECT emails.id
						FROM emails OUTER LEFT JOIN email_links ON emails.id=email_links.email_id
						WHERE emails.email=:email AND email_links.id IS NULL
					);
				ESQL;
			$stmt = $this->pdo->prepare( $sql );
			$stmt->bindParam( ":email", $email, PDO::PARAM_STR );
			$stmt->execute();
		} catch ( Exception $e ) {
			return $e->getMessage();
		}
		return $result;
	}

} // class Mails


class AjaxServices extends Mails {

	protected $userRoot;
	protected $dbFieldList = array();

	public function setUserRoot( $path ) {
		$this->userRoot = $path;
	}
	public function setDbFieldList( $list ) {
		$this->dbFieldList = $list;
	}

	// ==================================================================
	// メイン
	// ==================================================================
	public function main() {
		$returnCode[ 'status' ] = 'NOFUNCTION_ERROR';
		$func = $_POST[ 'func' ];
		if ( $func ) {
			switch ( strtoupper( $func ) ) {
				case 'INSERT':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'set' ] ) || count( $_POST[ 'set' ] ) == 0 ) break;
					$returnCode[ 'status' ] = "";
					try {
						$fieldArray = array();
						$fieldTagArray = array();
						$valueArray = array();
						foreach ( $_POST[ 'set' ] as $key => $value ) {
							if ( !in_array( $key, $this->dbFieldList ) ) {
								$returnCode[ 'status' ] = "ILLEGAL_FIELD_NAME ERROR";
								echo json_encode( $returnCode );
								exit;
							}
							$fieldTagArray[] = ":{$key}";
							$fieldArray[] = $key;
						}
						$stmt = $this->pdo->prepare( "INSERT INTO user_hub (" .  implode( ',', $fieldArray ) . ") VALUES (" . implode( ',', $fieldTagArray ) . ");" );
						$setArray = array();
						foreach ( $_POST[ 'set' ] as $key => $value ) {
							$stmt->bindValue( ":{$key}", $value, PDO::PARAM_STR );		// すべて文字列型
							$setArray[] = "{$key}=[{$value}]";
						}
						$stmt->execute();
						$userId = $this->pdo->lastInsertId();
						$stmt = $this->pdo->query( "SELECT name FROM user_hub WHERE id={$userId};" );
						$userInfo = $stmt->fetch();
						if ( $_POST[ 'signin_id' ] ) {
							$this->logger( 'REGISTER_USER', $userId, $userInfo[ 'name' ], implode( ", ", $setArray ), $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					$returnCode[ 'user_id' ] = strval( $userId );
					$returnCode[ 'updated' ] = $_POST[ 'set' ];
					break;
				case 'UPDATE':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'set' ] ) || count( $_POST[ 'set' ] ) == 0 ) break;
					if ( !isset( $_POST[ 'user_id' ] ) || !is_numeric( $_POST[ 'user_id' ] ) ) break;
					$userId = $_POST[ 'user_id' ];
					$returnCode[ 'status' ] = "";
					try {
						$setArray = array();
						foreach ( $_POST[ 'set' ] as $key => $value ) {
							if ( !in_array( $key, $this->dbFieldList ) ) {
								$returnCode[ 'status' ] = "ILLEGAL_FIELD_NAME ERROR";
								echo json_encode( $returnCode );
								exit;
							}
							$setArray[] = "{$key}=:{$key}";
						}
						$stmt = $this->pdo->prepare( "UPDATE user_hub SET " .  implode( ',', $setArray ) . " WHERE id={$userId};" );
						$setArray = array();
						foreach ( $_POST[ 'set' ] as $key => $value ) {
							$stmt->bindValue( ":{$key}", $value, PDO::PARAM_STR );		// すべて文字列型
							$setArray[] = "{$key}=[{$value}]";
						}
						$stmt->execute();
						$stmt = $this->pdo->query( "SELECT name FROM user_hub WHERE id={$userId};" );
						$userInfo = $stmt->fetch();
						if ( $_POST[ 'signin_id' ] ) {
							$this->logger( 'UPDATE_USER', $userId, $userInfo[ 'name' ], implode( ", ", $setArray ), $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					$returnCode[ 'user_id' ] = strval( $userId );
					$returnCode[ 'updated' ] = $_POST[ 'set' ];
					break;
				case 'DELETE':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'user_id' ] ) || !is_numeric( $_POST[ 'user_id' ] ) ) break;
					$userId = $_POST[ 'user_id' ];
					try {
						$stmt = $this->pdo->query( "SELECT name FROM user_hub WHERE id={$userId};" );
						$userInfo = $stmt->fetch();
						$sql = "DELETE FROM emails WHERE user_id={$userId};";
						$stmt = $this->pdo->query( $sql );
						$sql = "DELETE FROM user_hub WHERE id={$userId};";
						$stmt = $this->pdo->query( $sql );
						if ( $_POST[ 'signin_id' ] ) {
							$this->logger( 'DELETE_USER', $userId, $userInfo[ 'name' ], "", $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					$returnCode[ 'status' ] = "SUCCESS";
					break;
				case 'INSERT_EMAIL':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'user_id' ] ) || !is_numeric( $_POST[ 'user_id' ] ) ) break;
					if ( !isset( $_POST[ 'set' ][ 'email' ] ) ) break;
					$userId = $_POST[ 'user_id' ];
					$email = $_POST[ 'set' ][ 'email' ];
					try {
						$returnCode[ 'status' ] = "EXISTS_ERROR";
						$this->pdo->query( "BEGIN IMMEDIATE" );
						$stmt = $this->pdo->prepare( "SELECT user_id, email FROM emails WHERE email=:email;" );
						$stmt->bindValue( ":email", $email, PDO::PARAM_STR );
						$stmt->execute();
						$rows = $stmt->fetchAll();
						if ( count( $rows ) == 0 || is_null( $rows[ 0 ][ 'user_id' ] ) ) {
							if ( count( $rows ) == 0 ) {
								$stmt = $this->pdo->prepare( "INSERT INTO emails ( user_id, email ) VALUES ( :user_id, :email );" );
							} else {
								$stmt = $this->pdo->prepare( "UPDATE emails SET user_id=:user_id WHERE email=:email;" );
							}
							$stmt->bindValue( ":user_id", $userId, PDO::PARAM_INT );
							$stmt->bindValue( ":email", $email, PDO::PARAM_STR );
							$stmt->execute();
							$returnCode[ 'status' ] = "SUCCESS";
							$stmt = $this->pdo->prepare( "SELECT id, name FROM user_hub WHERE id=?;" );
							$stmt->execute( array( $userId ) );
							$userInfo = $stmt->fetch();
							if ( $_POST[ 'signin_id' ] ) {
								$userInfo[ 'id' ] = $userInfo[ 'id' ] ?? "*";
								$userInfoStr = $userInfo[ 'id' ] . ":" . $userInfo[ 'name' ];
								$this->logger( 'REGISTER_EMAIL', $userInfo[ 'id' ], $userInfo[ 'name' ], $email, $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
							}
						}
						$this->pdo->query( "COMMIT" );
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					$returnCode[ 'updated' ] = $_POST[ 'set' ];
					$returnCode[ 'user_id' ] = $userId;
					break;
				case 'DELETE_EMAIL':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'user_id' ] ) || !is_numeric( $_POST[ 'user_id' ] ) ) break;
					if ( !isset( $_POST[ 'email' ] ) ) break;
					$userId = $_POST[ 'user_id' ];
					$email = $_POST[ 'email' ];
					try {
						$this->pdo->query( "BEGIN IMMEDIATE" );
						$stmt = $this->pdo->prepare( "SELECT id, name FROM user_hub WHERE id=?;" );
						$stmt->execute( array( $userId ) );
						$userInfo = $stmt->fetch();
						$stmt = $this->pdo->prepare( "DELETE FROM emails WHERE email=?;" );
						$stmt->execute( array( $email ) );
						$stmt = $this->pdo->prepare( "DELETE FROM email_links WHERE email=?;" );
						$stmt->execute( array( $email ) );
						$this->pdo->query( "COMMIT" );
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					$returnCode[ 'status' ] = "SUCCESS";
					if ( $_POST[ 'signin_id' ] ) {
						$userInfo[ 'id' ] = $userInfo[ 'id' ] ?? "*";
						$this->logger( 'DEREGISTER_EMAIL', $userInfo[ 'id' ], $userInfo[ 'name' ], $email, $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
					}
					break;
				case 'APPEND_CC':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'status_area' ] ) ) break;
					$returnCode[ 'status_area' ] = $_POST[ 'status_area' ];
					if ( !isset( $_POST[ 'account' ] ) ) break;
					if ( !isset( $_POST[ 'email' ] ) ) break;
					if ( !isset( $_POST[ 'list_id' ] ) ) break;
					$email = $_POST[ 'email' ];
					$account = $_POST[ 'account' ];
					$returnCode[ 'status' ] = $this->appendCc( $account, $email );
					$returnCode[ 'list_id' ] = $_POST[ 'list_id' ];
					$returnCode[ 'email' ] = $_POST[ 'email' ];
					if ( $_POST[ 'signin_id' ] ) {
//						if ( $returnCode[ 'status' ] == "APPENDED" || $returnCode[ 'status' ] == "APPENDED_MOD_ENVELOPE" ) {
						if ( $returnCode[ 'status' ] == "APPENDED" ) {
							$this->logger( 'APPEND_CC', $account, $this->getUserNameByEmail( $email ), $email, $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
				case 'DELETE_CC':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'status_area' ] ) ) break;
					$returnCode[ 'status_area' ] = $_POST[ 'status_area' ];
					if ( !isset( $_POST[ 'list_id' ] ) ) break;
					if ( !isset( $_POST[ 'account' ] ) ) break;
					if ( !isset( $_POST[ 'email' ] ) ) break;
					$email = $_POST[ 'email' ];
					$account = $_POST[ 'account' ];
					$returnCode[ 'list_id' ] = $_POST[ 'list_id' ];
					if ( isset( $_POST[ 'count_id' ] ) ) {
						$returnCode[ 'count_id' ] = $_POST[ 'count_id' ];
					}
					$ownerName = $this->getUserNameByEmail( $email );
//					if ( count( $this->searchAddressCc( $_POST[ 'account' ], $_POST[ 'email' ] ) ) == 0 ) break;
					$returnCode[ 'status' ] = $this->deleteCc( $_POST[ 'account' ], $_POST[ 'email' ] );
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "DELETED" ) {
							$this->logger( 'DELETE_CC', $account, $ownerName, $email, $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
				case 'SET_MAILBOX_COMMENT':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'status_area' ] ) ) break;
					$returnCode[ 'status_area' ] = $_POST[ 'status_area' ];
					if ( !isset( $_POST[ 'comment_id' ] ) ) break;
					if ( !isset( $_POST[ 'account' ] ) ) break;
					if ( !isset( $_POST[ 'comment' ] ) ) break;
					$commentPath = $this->getMailPath() . "/{$_POST[ 'account' ]}/.comment";
					file_put_contents( $commentPath, $_POST[ 'comment' ] );
					$returnCode[ 'status' ] = "SUCCESS";
					$returnCode[ 'comment_id' ] = $_POST[ 'comment_id' ];
					$returnCode[ 'comment' ] = $_POST[ 'comment' ];
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "SUCCESS" ) {
							$this->logger( 'SET_CC_COMMENT', $account, '', $_POST[ 'comment' ], $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
				case 'APPEND_FML':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'status_area' ] ) ) break;
					$returnCode[ 'status_area' ] = $_POST[ 'status_area' ];
					if ( !isset( $_POST[ 'account' ] ) ) break;
					if ( !isset( $_POST[ 'email' ] ) ) break;
					if ( !isset( $_POST[ 'list_id' ] ) ) break;
					$email = $_POST[ 'email' ];
					$account = $_POST[ 'account' ];
					$returnCode[ 'status' ] = $this->appendFml( $account, $email );
					$returnCode[ 'list_id' ] = $_POST[ 'list_id' ];
					$returnCode[ 'email' ] = $_POST[ 'email' ];
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "APPENDED" ) {
							$this->logger( 'APPEND_ML', $account, $this->getUserNameByEmail( $email ), $email, $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
				case 'DELETE_FML':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'status_area' ] ) ) break;
					$returnCode[ 'status_area' ] = $_POST[ 'status_area' ];
					if ( !isset( $_POST[ 'list_id' ] ) ) break;
					if ( !isset( $_POST[ 'account' ] ) ) break;
					if ( !isset( $_POST[ 'email' ] ) ) break;
					$returnCode[ 'list_id' ] = $_POST[ 'list_id' ];
					$returnCode[ 'count_id' ] = $_POST[ 'count_id' ];
					$email = $_POST[ 'email' ];
					$account = $_POST[ 'account' ];
//					if ( !$this->searchAddressFml( $account, $email ) ) break;
					$returnCode[ 'status' ] = $this->deleteFml( $account, $email );
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "DELETED" ) {
							$this->logger( 'DELETE_ML', $account, $this->getUserNameByEmail( $email ), $email, $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
				case 'SET_FML_COMMENT':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'status_area' ] ) ) break;
					$returnCode[ 'status_area' ] = $_POST[ 'status_area' ];
					if ( !isset( $_POST[ 'comment_id' ] ) ) break;
					if ( !isset( $_POST[ 'account' ] ) ) break;
					if ( !isset( $_POST[ 'comment' ] ) ) break;
					$commentPath = $this->getFmlPath() . "/{$_POST[ 'account' ]}/.comment";
					file_put_contents( $commentPath, $_POST[ 'comment' ] );
					$returnCode[ 'status' ] = "SUCCESS";
					$returnCode[ 'comment_id' ] = $_POST[ 'comment_id' ];
					$returnCode[ 'comment' ] = $_POST[ 'comment' ];
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "SUCCESS" ) {
							$this->logger( 'SET_ML_COMMENT', $account, '', $_POST[ 'comment' ], $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;

				case 'FML_CUSTOMIZE':
					$returnCode[ 'status' ] = "ERROR";
					if ( $this->$customFml->setCustomize() ) $returnCode[ 'status' ] = "ON";
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "ON" ) {
							$this->logger( 'SET_FML_CUSTOM', $account, '', 'ON', $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;

				case 'FML_NORMALIZE':
					$returnCode[ 'status' ] = "ERROR";
					if ( $this->$customFml->resetCustomize() ) $returnCode[ 'status' ] = "OFF";
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "OFF" ) {
							$this->logger( 'RESET_FML_CUSTOM', $account, '', 'OFF', $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
/*
				case 'SET_MOD_ENVELOPE':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'value' ] ) ) break;
					$returnCode[ 'status' ] = "ILLEGAL_DATA_ERROR";
					if ( !in_array( $_POST[ 'value' ], array( "ON", "OFF" ) ) ) break;
					setProperty( "mod_envelope", $_POST[ 'value' ] );
					$currentModEnvelope = getProperty( "mod_envelope" );
					$this->setDefaultModEnvelope( $currentModEnvelope == "ON" ? true : false );
					$this->repairModEnvelopeAll();
					if ( $currentModEnvelope == "ON" ) {
						$returnCode[ 'status' ] = "CUSTOM_SCRIPT_ERROR";
						$target = $this->userRoot . "/custom_script";
						if ( !is_dir( $target ) ) {
							if ( !mkDir( $target, 0727 ) ) {
								break;
							}
						}
						$target .= "/change_from.pl";
						if ( !file_exists( $target ) ) {
							if ( copy( "./misc/custom_script/change_from.pl", $target ) ) {
								chmod( $target, 0700 );
							} else {
								break;
							}
						}
//						//
//						// メールボックスに警告用のダミーアカウントを設置する
//						// * 新規メールアカウント設置に支障が出たので廃止 *
//						$returnCode[ 'status' ] = "WARNING_SETTING_ERROR";
//						$target = $this->userRoot . "/MailBox/!! warning !!";
//						if ( !is_dir( $target ) ) {
//							if ( !mkDir( $target, 0700 ) ) {
//								break;
//							}
//						}
//						$target .= "/.comment";
//						if ( !file_exists( $target ) ) {
//							if ( copy( "./!! warning !!/.comment", $target ) ) {
//								chmod( $target, 0644 );
//							} else {
//								break;
//							}
//						}
					} else {
//						$returnCode[ 'status' ] = "WARNING_REMOVE_ERROR";
//						$target = $this->userRoot . "/MailBox/!! warning !!";
//						$this->remove_directory( $target );
					}
					$returnCode[ 'status' ] = $currentModEnvelope;
					break;
*/
				case 'UPDATE_PROPERTY':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'set' ] ) || count( $_POST[ 'set' ] ) == 0 ) break;
					if ( !isset( $_POST[ 'col' ] ) || !isset( $_POST[ 'set' ][ 'key' ] ) || !isset( $_POST[ 'set' ][ 'value' ] ) ) break;
					$key = $_POST[ 'set' ][ 'key' ];
					$value = $_POST[ 'set' ][ 'value' ];
					$commentExists = isset( $_POST[ 'set' ][ 'comment' ] );
					$comment = ( $commentExists ) ? $_POST[ 'set' ][ 'comment' ] : "";
					$returnCode[ 'status' ] = "";
					try {
						$sql = "INSERT INTO property ( key, value, comment ) VALUES ( :key, :value, :comment ) ";
						$sql .= "ON CONFLICT ( key ) DO UPDATE SET value=:value";
						$sql .= ( $commentExists ) ? ", comment=:comment" : "";
						$sql .= " WHERE key=:key;";
						$stmt = $this->pdo->prepare( $sql );
						$stmt->bindParam( ":key", $key, PDO::PARAM_STR );
						$stmt->bindParam( ":value", $value, PDO::PARAM_STR );
						if ( $commentExists ) $stmt->bindParam( ":comment", $comment, PDO::PARAM_STR );
						$stmt->execute();
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					$returnCode[ 'col' ] = $_POST[ 'col' ];
					$returnCode[ 'updated' ] = $_POST[ 'set' ];
					$returnCode[ 'status' ] = "UPDATED";
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "UPDATED" ) {
							$this->logger( 'UPDATE_PROPERTY', $key, $value, $comment, $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
				case 'DELETE_PROPERTY':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'set' ] ) || count( $_POST[ 'set' ] ) == 0 ) break;
					if ( !isset( $_POST[ 'col' ] ) || !isset( $_POST[ 'set' ][ 'key' ] ) ) break;
					$key = $_POST[ 'set' ][ 'key' ];
					$key = $_POST[ 'set' ][ 'key' ];
					$value = $_POST[ 'set' ][ 'value' ];
					$commentExists = isset( $_POST[ 'set' ][ 'comment' ] );
					$comment = ( $commentExists ) ? $_POST[ 'set' ][ 'comment' ] : "";
					try {
						$sql = "DELETE FROM property WHERE key=:key;";
						$stmt = $this->pdo->prepare( $sql );
						$stmt->bindParam( ":key", $key, PDO::PARAM_STR );
						$stmt->execute();
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					$returnCode[ 'col' ] = $_POST[ 'col' ];
					$returnCode[ 'updated' ] = $_POST[ 'set' ];
					$returnCode[ 'status' ] = "DELETED";
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "DELETED" ) {
							$this->logger( 'DEKETE_PROPERTY', $key, $value, $comment, $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
				case 'UPDATE_SIGNIN_INFO':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'set' ] ) || count( $_POST[ 'set' ] ) == 0 ) break;
					if ( !isset( $_POST[ 'col' ] ) || !isset( $_POST[ 'set' ][ 'user' ] ) || !isset( $_POST[ 'set' ][ 'root' ] ) ) break;
					$userName = ( isset( $_POST[ 'set' ][ 'user_name' ] ) ) ?  $_POST[ 'set' ][ 'user_name' ] : "";
					if ( !isset( $_POST[ 'set' ][ 'password' ] ) && $userName == "" ) break;
					$userId = $_POST[ 'set' ][ 'user' ];
					$password = $_POST[ 'set' ][ 'password' ];
					$isRoot = ( $_POST[ 'set' ][ 'root' ] == "YES" ) ? 1 : 0;
					$returnCode[ 'status' ] = "";
					try {
						if ( $password == "" ) {
							$sql = "UPDATE signin_info SET user_name=:user_name, root=:root WHERE user=:user;";
						} else {
							$sql = "INSERT INTO signin_info ( user, user_name, password, root ) VALUES ( :user, :user_name, :password, :root ) ";
							$sql .= "ON CONFLICT ( user ) DO UPDATE SET user_name=:user_name, password=:password WHERE user=:user;";
						}
						$stmt = $this->pdo->prepare( $sql );
						$stmt->bindParam( ":user", $userId, PDO::PARAM_STR );
						$stmt->bindParam( ":user_name", $userName, PDO::PARAM_STR );
						$stmt->bindParam( ":root", $isRoot, PDO::PARAM_INT );
						if ( $password !== "" ) {
							$stmt->bindParam( ":password", password_hash( $password, PASSWORD_DEFAULT ), PDO::PARAM_STR );
						}
						$stmt->execute();
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					$returnCode[ 'col' ] = $_POST[ 'col' ];
					$returnCode[ 'updated' ] = $_POST[ 'set' ];
					$returnCode[ 'status' ] = "UPDATED";
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "UPDATED" ) {
							$this->logger( 'UPDATE_SIGNIN_INFO', $userId, '', '', $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
				case 'DELETE_SIGNIN_INFO':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'set' ] ) || count( $_POST[ 'set' ] ) == 0 ) break;
					if ( !isset( $_POST[ 'col' ] ) || !isset( $_POST[ 'set' ][ 'user' ] ) ) break;
					$userId = $_POST[ 'set' ][ 'user' ];
					try {
						$sql = "DELETE FROM signin_info WHERE user=:user;";
						$stmt = $this->pdo->prepare( $sql );
						$stmt->bindParam( ":user", $userId, PDO::PARAM_STR );
						$stmt->execute();
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					$returnCode[ 'col' ] = $_POST[ 'col' ];
					$returnCode[ 'updated' ] = $_POST[ 'set' ];
					$returnCode[ 'status' ] = "DELETED";
					if ( $_POST[ 'signin_id' ] ) {
						if ( $returnCode[ 'status' ] == "DELETED" ) {
							$this->logger( 'DELETE_SIGNIN_INFO', $userId, '', '', $_POST[ 'signin_id' ], $_POST[ 'signin_user' ] );
						}
					}
					break;
				case 'TOKEN_REQUEST':
					$returnCode[ 'status' ] = "NO_DATA_ERROR";
					if ( !isset( $_POST[ 'token_seed' ] ) ) break;
					try {
						$unixTime = time();
						$token = md5( strval( $unixTime ) . $_POST[ 'token_seed' ] );
						$stmt = $this->pdo->prepare( "INSERT INTO token ( time, token ) VALUES ( :time, :token );" );
						$stmt->bindValue( ":time", $unixTime, PDO::PARAM_INT );
						$stmt->bindValue( ":token", $token, PDO::PARAM_STR );
						$stmt->execute();
						$expireTime = $unixTime - 300;
						$stmt = $this->pdo->prepare( "DELETE FROM token WHERE time < ?;" );
						$stmt->execute( array( $expireTime ) );
						$returnCode[ 'status' ] = "SUCCESS";
						$returnCode[ 'token' ] = $token;
					} catch ( Exception $e ) {
						$returnCode[ 'status' ] = $e->getMessage();
						echo json_encode( $returnCode );
						exit;
					}
					break;
				default:
					$returnCode[ 'status' ] = 'FUNCTION_ERROR';
			}
		}
		echo json_encode( $returnCode );
		exit;
	}

	//
	// 名前の取得
	//
	protected function getUserNameByEmail( $email ) {
		$sql = "SELECT user_hub.id, name FROM user_hub INNER JOIN emails ON user_hub.id=emails.user_id WHERE email=?;";
		$stmt = $this->pdo->prepare( $sql );
		$stmt->execute( array( $email ) );
		$userInfo = $stmt->fetch();
		if ( isset( $userInfo[ 'name' ] ) ) {
			return $userInfo[ 'name' ];
		}
		return "";
	}

	//
	// ログ
	//
	protected function logger( $action, $account, $accountOwner, $data, $signinId, $signinUser ) {
		try {
			$unixTime = time();
			$sql = "INSERT INTO log ( action, account, account_owner, data, signin_id, signin_user, time ) VALUES ( :action, :account, :account_owner, :data, :signin_id, :signin_user, :time );";
			$stmt = $this->pdo->prepare( $sql );
			$stmt->bindParam( ":action", $action, PDO::PARAM_STR );
			$stmt->bindParam( ":account", $account, PDO::PARAM_STR );
			$stmt->bindParam( ":account_owner", $accountOwner, PDO::PARAM_STR );
			$stmt->bindParam( ":data", $data, PDO::PARAM_STR );
			$stmt->bindParam( ":signin_id", $signinId, PDO::PARAM_STR );
			$stmt->bindParam( ":signin_user", $signinUser, PDO::PARAM_STR );
			$stmt->bindParam( ":time", $unixTime, PDO::PARAM_INT );
			$stmt->execute();
		} catch ( Exception $e ) {
			return $e->getMessage();
		}
	}

	//
	// 再帰的フォルダ削除サブルーチン
	//
	protected function remove_directory( $dir ) {
		$files = array_diff( scandir( $dir ), array( '.', '..' ) );
		foreach ( $files as $file ) {
			if ( is_dir( "$dir/$file" ) ) {
				$this->remove_directory( "$dir/$file" );
			} else {
				unlink( "$dir/$file" );
			}
		}
		return rmdir( $dir );
	}

} // class AjaxServices

?>
