<html lang="ja">
<head>
<?php include( 'common.php' ); include( 'mail_handler.php' ); include( 'customize_fml.php' ); ?>
<meta charset="utf-8">
<link rel="stylesheet" href="<?php addUpdateQuery( "custom.css" ); ?>" />
<link rel="stylesheet" href="theme.default.min.css" />
<script src="jquery-3.7.1.min.js"></script>
<script src="jquery.cookie.js"></script>
<script src="jquery.tablesorter.min.js"></script>
<script src="<?php addUpdateQuery( "custom.js" ); ?>"></script>
</head>
<?php
/* =====================================================
	セッション管理
 ===================================================== */
$signinUser = "";
$isRoot = true;
if ( getPropertyBool( "session_control" ) || is_null( getProperty( "session_control" ) ) ) {
	$settingPage = "";
	session_name( SESSION_ID );
	session_start();
	if ( ! $_SESSION[ 'signin_id' ] ) die( file_get_contents( "forbidden.txt" ) );
	$isRoot = false;
	if ( $_SESSION[ 'root' ] ) $isRoot = true;
	$signinId = $_SESSION[ 'signin_id' ];
	$signinUser = $_SESSION[ 'signin_user' ];
	$exitMsg = ( $_SESSION[ 'home' ] ) ? "会員専用サイトへ戻る" : "サインアウト";
	$exitMsg = "<a href=\"{$scriptHomeUri}/\" class=\"link_button\">{$exitMsg}</a>";
	$signinIndicator = "user : ";
	$signinIndicator .= ( $_SESSION[ 'signin_user' ] ) ? $_SESSION[ 'signin_user' ] : $_SESSION[ 'signin_id' ];
}
//if ( $isRoot ) {
	$settingPage = "<a class=\"link_button\" href=\"{$scriptHomeUri}/settings.php\">設定</a> ";
	if ( $signinIndicator == "" ) {
		$signinIndicator = $settingPage;
	} else {
		$signinIndicator = "{$signinIndicator} {$settingPage}{$exitMsg}";
	}
//} else {
//	$signinIndicator = $signinIndicator . $exitMsg;
//}
//
// mailハンドラクラスのセットアップ
//
$fmlComment = getPropertyBool( "fml_comment" );
$mails = new Mails( MAINDB_DSN );
$mails->setFmlPath( $fmlPath );
$mails->setMailPath( $mailPath );
//
// customizeFMLクラスのセットアップ
//
$customFml = new customizeFml();
$customFml->setFmlPath( $fmlPath );
//
// オプション
//
$showMailboxPath = getPropertyBool( 'show_mailbox_path' );
$showDomain = getPropertyBool( 'show_domain' );
?>

<!-- HTML メインボディ：ここから -->

<body id="mailbox_admin">
<div class="signin_user"><?php echo $signinIndicator; ?></div>
<h1><?php echo $mainTitle ?></h1>
<?php
	echo "<input type=\"hidden\" id=\"signin_id\" value=\"{$signinId}\" />\n";
	echo "<input type=\"hidden\" id=\"signin_user\" value=\"{$signinUser}\" />\n";
	echo "<h3>メーリングリストの登録状況</h3>\n";
	echo "<div id=\"fml_block\">\n";
	echo "<div class=\"outer_block\">\n";
	if ( $showMailboxPath ) echo "<div>{$fmlPath}</div>\n";
	if ( getPropertyBool( "fml_options" ) && $isRoot ) {
		echo "<div>FML CUSTOMIZE <input id=\"fml_customize\" type=\"checkbox\" checked=\"checked\" value=\"\" /></div>\n";
	}
	if ( $showDomain ) echo ( $demoMode ) ? "<small class=\"domain\">@{$exampleDomain}</small>" : "<small class=\"domain\">@{$domainName}</small>";
	echo "<div class=\"top_navi\"><a class=\"link_button\" href=\"{$scriptHomeUri}/members.php\">リストビュー</a></div>\n";
	echo "<input type=\"hidden\" id=\"user_id\" value=\"{$userId}\" />\n";
	echo "<input type=\"hidden\" id=\"user_name\" value=\"{$userName}\" />\n";

	$pdo = new PDO( MAINDB_DSN );

/* -----------------------------------------------------
  FML セクション
 ------------------------------------------------------- */
$customCount = 0;
if ( is_dir( $fmlPath ) ) {
	if ( $dh = opendir( $fmlPath ) ) {
		$i = 1;
		while ( ( $mailbox = readdir( $dh ) ) !== false ) {
			//
			// メーリングリストを巡回する
			//
			$mlDirPath = $fmlPath . '/' . $mailbox;
			$membersPath = $mlDirPath . "/members";
			if ( $mailbox != "." and $mailbox != ".." and is_dir( $mlDirPath ) and file_exists( $membersPath ) ) {
				if ( $fmlComment ) {
					if ( !file_exists( "$mlDirPath/.comment" ) ) {	
						file_put_contents( "$mlDirPath/.comment", "" );
					}
					$comment = file_get_contents( "$mlDirPath/.comment" );
					$comment = ( $comment == "" ) ? "[コメントがありません]" : $comment;
				}

				$sql = <<<ESQL
				SELECT
					user_id, reading, name, email_links.email, account
				FROM
					email_links
					LEFT OUTER JOIN emails
					ON emails.id=email_links.email_id
					LEFT OUTER JOIN user_hub
					ON user_hub.id=emails.user_id
				WHERE
					account='{$mailbox}' AND system='ml' AND session=0;
				ESQL;
				try {
					$stmt = $pdo->query( $sql );
				} catch ( Exception $e ) {
					echo $e->getMessage();
				}

				$result = array();
				$index = 0;
				$dbMailList = array();
				while ( $result[ $index ] = $stmt->fetch() ) {
//					echo "<div>" . $result[ $index ][ 'user_id' ] . " : " . $result[ $index ][ 'account' ] . " : " . $result[ $index ][ 'email' ] . "</div>\n";
					$dbMailList[ $result[ $index ][ 'email' ] ] = $result[ $index ];
					$index++;
				}

				//
				// FMLのカスタマイズチェック
				//
				if ( $customFml->checkCustomize( $mailbox ) > 0 ) {
					$customCount++;
					$custom = "YES";
				} else {
					$custom = "NONE";
				}

				//
				// FMLのメールアドレスリストを取得
				//
				$members = $mails->getFmlUserSorted( $membersPath );
				$mailboxId = str_replace( ".", "_", $mailbox );
				echo "<div class=\"mailbox\">\n";
				echo "<h4 id=\"fml_{$mailbox}\" class=\"section_title\">$mailbox <small>(ML : <span id=\"count_fml{$i}\">" . count( $members ) . "</span> / CUSTOM : {$custom})</small></h4>\n";
				echo "<input id=\"fml_account{$i}\" type=\"hidden\" value=\"{$mailbox}\" />\n";
				if ( $fmlComment ) {
					echo "<p id=\"fml_comment{$i}\" class=\"indent20em link_button fml_comment\">{$comment}</p>\n";
				}
				echo "<div id=\"fml_{$mailbox}_members\" class=\"hidden_block\">\n";
				echo "<span id=\"fml_status_area{$i}\" class=\"status_area\"></span>\n";
				echo "<table id=\"listview_fml{$i}\" class=\"tablesorter-default listview\">\n";
				echo "<thead><tr><th class=\"middle\">よみがな</th><th class=\"middle\">氏名</th><th class=\"wide\">メール</th><th class=\"narrow\">&nbsp;</th></tr></thead>\n";
				echo "<tbody>\n";
				$id = "{$mailbox}_member";
				$j = 1;
				foreach ( $members as $member ) {
					//
					// メールアドレスがサーバーFMLに存在し、DBに登録がない場合の処理
					//
					$serverSideOnly = "";
					$serverSideOnlyMsg = "";
					$registerDbButton = "";
					if ( isset( $dbMailList[ $member[ 'email' ] ] ) ) {
						unset( $dbMailList[ $member[ 'email' ] ] );
					} else {
						$serverSideOnly = " server_side_only";
						$serverSideOnlyMsg = "<div class=\"option_controls\">マネージャー未登録<div>";
						$registerDbButton = "<div class=\"option_controls\"><a id=\"register_fml{$i}_{$j}\" href=\"#\" class=\"register_fml link_button\">登録</a></div>";
					}

					echo "<tr id=\"list_fml{$i}_{$j}\" class=\"odd{$serverSideOnly}\">\n";
					echo "<td class=\"middle\">{$member[ 'reading' ]}</td>";
					echo "<td class=\"middle\"><a href=\"{$scriptHomeUri}/members.php?view_id={$member[ 'id' ]}\">{$member[ 'name' ]}</a></td>";
					echo "<td id=\"fml_mail_address{$i}_{$j}\" class=\"middle\"><span class=\"email\">{$member[ 'email' ]}</span>{$serverSideOnlyMsg}</td>";
					echo "<td class=\"narrow\"><a id=\"delete_fml{$i}_{$j}\" href=\"#\" class=\"delete_fml link_button\">削除</a>{$registerDbButton}</td>\n";
					echo "</tr>\n";
					$j++;
				}
				//
				// メールアドレスがDBに登録されているが、サーバーFMLにない場合の処理
				//
				foreach( $dbMailList as $key => $mailSet ) {
					echo "<tr id=\"list_fml{$i}_{$j}\" class=\"odd db_side_only\">\n";
					echo "<td class=\"middle\">{$mailSet[ 'reading' ]}</td>";
					$userId = $mailSet[ 'user_id' ];
					if ( $userId == 0 ) {
						$anchorOpen = "";
						$anchorClose = "";
					} else {
						$anchorOpen = "<a href=\"{$scriptHomeUri}/members.php?view_id={$userId}\">";
						$anchorClose = "</a>";
					}
					echo "<td class=\"middle\">{$anchorOpen}{$mailSet[ 'name' ]}{$anchorClose}</td>";
					echo "<td id=\"fml_mail_address{$i}_{$j}\" class=\"middle\"><span class=\"email\">{$mailSet[ 'email' ]}</span><div class=\"option_controls\">サーバー未登録</div></td>";
					echo "<td class=\"narrow\"><a id=\"delete_fml{$i}_{$j}\" href=\"#\" class=\"delete_fml link_button\">削除</a>" .
						"<div class=\"option_controls\"><a id=\"register_db_fml{$i}_{$j}\" href=\"#\" class=\"register_fml link_button\">登録</a></div></td>\n";
					echo "</tr>\n";
					$j++;
				}
				echo "</tbody></table>\n";
//				echo "<div class=\"submit\"><input class=\"submit\" type=\"submit\" value=\"{$mailbox}の変更を登録する\" /></div>\n";
				echo "</div><!-- fml_n_members -->\n";
				echo "</div><!-- mailbox -->\n";
			}
			$i++;
		}
		closedir( $dh );
		echo "<input id=\"fml_customize_count\" type=\"hidden\" value=\"{$customCount}\" /></div>\n";
	}
}

?>
		</div><!-- top_navi -->
	</div><!-- outer_block -->
</div><!-- fml_block -->

<div id="mail_block">
<h3>メールアカウントの転送登録状況</h3>
<?php
	echo "<div class=\"outer_block\">\n";
	if ( $showMailboxPath ) echo "<span>{$mailPath}</span>\n";
	if ( $showDomain ) echo ( $demoMode ) ? "<small class=\"domain\">@{$exampleDomain}</small>" : "<small class=\"domain\">@{$domainName}</small>";
	echo "<div class=\"top_navi\"><a class=\"link_button\" href=\"{$scriptHomeUri}/members.php\">リストビュー</a></div>\n";

//	$comment = "<li>上記チェックボックスにチェックを入れると、Gmailへの転送が着信拒否されることへの回避策として、メールのエンベロープFromを転送サーバーのドメインに差し替えるフィルターを設定します。</li>";
//	$comment .= "<li>この設定をした場合、さくらインターネット標準コントロールパネル（以下「さくら標準CP」）での転送先確認および編集ができなくなります（無理に編集するとフィルター設定した転送メールアドレスが消失します）。</li>";
//	$comment .= "<li><span style=\"color: red;\">さくら標準CPでの迷惑フィルター設定等は、必ずチェックを外した状態で作業してください。</span></li>";
//	$checked = getPropertyBool( "mod_envelope" ) ? "checked=\"checked\"" : "";
//	echo "<br />\n";
//	echo "<div class=\"top_navi\"><span id=\"status_area01\"></span>  <input type=\"checkbox\" id=\"set_mod_envelope\" {$checked} /> <label for=\"set_mod_envelope\">Gmail転送対策設定</label></div>\n";
//	echo "<ul style=\"font-size: x-small; background-color: #ffe; padding: 1em 1em 1em 2.5em;\">{$comment}</ul>";
/* -----------------------------------------------------
  Mail セクション
 ------------------------------------------------------- */
if ( is_dir( $mailPath ) ) {
	if ( $dh = opendir( $mailPath ) ) {
		while ( false !== ( $mailboxList[] = readdir( $dh ) ) );
		closedir( $dh );
		sort( $mailboxList );
		$i = 1;
		foreach ( $mailboxList as $mailbox ) {
			if ( $mailbox == false || $mailbox == "" || $mailbox[ 0 ] == "." || $mailbox[ 0 ] == "!" ) continue;
			$mlDirPath = $mailPath . '/' . $mailbox;
			$membersPath = $mlDirPath;
			if ( !is_dir( $mlDirPath ) || file_exists( "$mlDirPath/.is_ml_address" ) ) continue;
			$comment = file_get_contents( "$mlDirPath/.comment" );
			$comment = ( $comment == "" ) ? "[コメントがありません]" : $comment;

			$sql = <<<ESQL
			SELECT
				user_id, reading, name, email_links.email, account
			FROM
				email_links
				LEFT OUTER JOIN emails
				ON emails.id=email_links.email_id
				LEFT OUTER JOIN user_hub
				ON user_hub.id=emails.user_id
			WHERE
				account='{$mailbox}' AND system='cc' AND session=0;
			ESQL;
			try {
				$stmt = $pdo->query( $sql );
			} catch ( Exception $e ) {
				echo $e->getMessage();
			}

			$result = array();
			$index = 0;
			$dbMailList = array();
			while ( $result[ $index ] = $stmt->fetch() ) {
//				echo "<div>" . $result[ $index ][ 'user_id' ] . " : " . $result[ $index ][ 'account' ] . " : " . $result[ $index ][ 'email' ] . "</div>\n";
				$dbMailList[ $result[ $index ][ 'email' ] ] = $result[ $index ];
				$index++;
			}

			$members = $mails->getCcUsersSorted( $membersPath );
			$mailboxId = str_replace( ".", "_", $mailbox );
			echo "<div class=\"mailbox\">\n";
			echo "<h4 id=\"cc_{$mailboxId}\" class=\"section_title\">{$mailbox} <small>(CC : <span id=\"count_cc{$i}\">" . count( $members ) . "</span>) <span class=\"status_cc{$i} status_area\"></span></small></h4>\n";
			echo "<input id=\"cc_account{$i}\" type=\"hidden\" value=\"{$mailbox}\" />\n";
			echo "<p id=\"cc_comment{$i}\" class=\"indent20em link_button mailbox_comment\">{$comment}</p>\n";
			echo "<div id=\"cc_{$mailboxId}_members\" class=\"hidden_block\">\n";
			echo "<span id=\"cc_status_area{$i}\" class=\"status_area\"></span>\n";
			echo "<table id=\"listview_cc{$i}\" class=\"tablesorter-default listview\">\n";
			echo "<thead><tr><th class=\"middle\">よみがな</th><th class=\"middle\">氏名</th><th class=\"wide\">メール</th><th class=\"narrow\">&nbsp;</th></tr></thead>\n";
			echo "<tbody>\n";
			$j = 1;
			foreach ( $members as $member ) {
				//
				// メールアドレスがサーバーMailBoxに存在し、DBに登録がない場合の処理
				//
				$serverSideOnly = "";
				$serverSideOnlyMsg = "";
				$registerDbButton = "";
				if ( isset( $dbMailList[ $member[ 'email' ] ] ) ) {
					unset( $dbMailList[ $member[ 'email' ] ] );
				} else {
					$serverSideOnly = " server_side_only";
					$serverSideOnlyMsg = "<div class=\"option_controls\">マネージャー未登録</div>";
					$registerDbButton = "<div class=\"option_controls\"><a id=\"register_cc{$i}_{$j}\" href=\"#\" class=\"register_cc link_button\">登録</a></div>";
				}
				$modEnvelope = $member[ 'mod_envelope' ] ? "*" : "";				//
				echo "<tr id=\"list_cc{$i}_{$j}\" class=\"odd{$serverSideOnly}\">\n";
				echo "<td class=\"middle\">{$member[ 'reading' ]}</td>";
				$name = ( $member[ 'name' ] == "" ) ? "" : "<a href=\"{$scriptHomeUri}/members.php?view_id={$member[ 'id' ]}\">{$member[ 'name' ]}</a>";
				echo "<td class=\"middle\">{$name}</td>";
				echo "<td id=\"cc_mail_address{$i}_{$j}\" class=\"middle\"><span class=\"email\">{$member[ 'email' ]}</span>{$serverSideOnlyMsg}</td>";
				echo "<td class=\"narrow\"><a id=\"delete_cc{$i}_{$j}\" href=\"#\" class=\"delete_cc link_button\">削除</a>{$registerDbButton}</td>\n";
				echo "</tr>\n";
				$j++;
			}
			//
			// メールアドレスがDBに登録されているが、サーバーMailBoxにない場合の処理
			//
			foreach( $dbMailList as $key => $mailSet ) {
				echo "<tr id=\"list_cc{$i}_{$j}\" class=\"odd db_side_only\">\n";
				echo "<td class=\"middle\">{$mailSet[ 'reading' ]}</td>";
				$userId = $mailSet[ 'user_id' ];
				if ( $userId == 0 ) {
					$anchorOpen = "";
					$anchorClose = "";
				} else {
					$anchorOpen = "<a href=\"{$scriptHomeUri}/members.php?view_id={$userId}\">";
					$anchorClose = "</a>";
				}
				echo "<td class=\"middle\">{$anchorOpen}{$mailSet[ 'name' ]}{$anchorClose}</td>";
				echo "<td id=\"cc_mail_address{$i}_{$j}\" class=\"middle\"><span class=\"email\">{$mailSet[ 'email' ]}</span>" .
					"<div class=\"option_controls\">サーバー未登録</div></td>";
				echo "<td class=\"narrow\"><a id=\"delete_cc{$i}_{$j}\" href=\"#\" class=\"delete_cc link_button\">削除</a>" .
					"<div class=\"option_controls\"><a id=\"register_db_cc{$i}_{$j}\" href=\"#\" class=\"register_cc link_button\">登録</a></div></td>\n";
				echo "</tr>\n";
				$j++;
			}
			echo "</tbody></table>\n";
			if ( getPropertyBool( "mbox_filter_view" ) ) {
				echo "<div class=\"mailfilter\"><pre>\n" . file_get_contents( $membersPath . '/.mailfilter' ) . "</pre></div>\n";
			}
			echo "</div></div>\n";
			$i++;
		}
	}
}
if ( !getPropertyBool( 'disable_copyright' ) ) echo "<div class=\"copyright\">{$copyright}</div>";

?>
	</div>
</div><!-- mail_block -->
</body>
</html>
