<html lang="ja">
<head>
<?php include( 'common.php' ); include( 'mail_handler.php' ); include( 'customize_fml.php' ); ?>
<meta charset="utf-8">
<link rel="stylesheet" href="<?php addUpdateQuery( "custom.css" ); ?>" />
<link rel="stylesheet" href="theme.default.min.css" />
<script src="jquery-3.7.1.min.js"></script>
<script src="jquery.cookie.js"></script>
<script src="jquery.tablesorter.min.js"></script>
<script src="<?php addUpdateQuery( "custom.js" ); ?>"></script>
</head>
<?php
/* =====================================================
	セッション管理
 ===================================================== */
$signinUser = "";
$isRoot = true;
if ( getPropertyBool( "session_control" ) || is_null( getProperty( "session_control" ) ) ) {
	$settingPage = "";
	session_name( SESSION_ID );
	session_start();
	if ( ! $_SESSION[ 'signin_id' ] ) die( file_get_contents( "forbidden.txt" ) );
	$isRoot = false;
	if ( $_SESSION[ 'root' ] ) $isRoot = true;
	$signinId = $_SESSION[ 'signin_id' ];
	$signinUser = $_SESSION[ 'signin_user' ];
	$exitMsg = ( $_SESSION[ 'home' ] ) ? "会員専用サイトへ戻る" : "サインアウト";
	$exitMsg = "<a href=\"{$scriptHomeUri}/\" class=\"link_button\">{$exitMsg}</a>";
	$signinIndicator = "user : ";
	$signinIndicator .= ( $_SESSION[ 'signin_user' ] ) ? $_SESSION[ 'signin_user' ] : $_SESSION[ 'signin_id' ];
}
//if ( $isRoot ) {
	$settingPage = " <a class=\"link_button\" href=\"{$scriptHomeUri}/settings.php\">設定</a> ";
	if ( $signinIndicator == "" ) {
		$signinIndicator = $settingPage;
	} else {
		$signinIndicator = $signinIndicator . $settingPage . $exitMsg;
	}
//} else {
//	$signinIndicator = $signinIndicator . $exitMsg;
//}
//
// mailハンドラクラスのセットアップ
//
$mails = new Mails( MAINDB_DSN );
$mails->setDefaultModEnvelope( getPropertyBool( "mod_envelope" ) );
$mails->setFmlPath( $fmlPath );
$mails->setMailPath( $mailPath );
//
// オプション
//
$simultaneousMailingStatus = getPropertyBool( "show_option01" );
$showGmailFilterStatus = getPropertyBool( "show_gmail_filter_status" );
$showDomain = getPropertyBool( "show_domain" );
?>

<!-- HTML メインボディ：ここから -->

<body>
<div class="signin_user"><?php echo $signinIndicator; ?></div>
<h1><?php echo $mainTitle ?></h1>
<h3>登録ユーザー管理</h3>
<div>
	<div id="status_area01"></div>
	<div class="outer_block">
<?php

echo "<input type=\"hidden\" id=\"signin_id\" value=\"{$signinId}\" />\n";
echo "<input type=\"hidden\" id=\"signin_user\" value=\"{$signinUser}\" />\n";

if ( isset( $_GET[ 'view_id' ] ) ) {
	$userId = $_GET[ 'view_id' ];
	if ( is_numeric( $userId ) ) {
		singleView( $userId, $mails );
	}
} else {
	if ( !listView() ) {
		singleView( 0, $mails );
	}
}

function singleView( $userId, &$mails ) {
	global $selfUri;
	global $selfUriQuery;
	global $scriptHomeUri;
	global $simultaneousMailingStatus;
	global $showGmailFilterStatus;
	global $copyright;
	global $demoMode;
	global $showDomain;
	global $exampleDomain;
	global $domainName;
	$domainTag = "";
	if ( $showDomain ) {
		$domainTag = ( $demoMode ) ? "<small class=\"domain\">@{$exampleDomain}</small>" : "<small class=\"domain\">@{$domainName}</small>";
	}
	try {
		$pdo = new PDO( MAINDB_DSN );
		if ( $userId == 0 ) {
			$sql = "SELECT 0 AS id, '' AS reading, '' AS name, '' AS organization, '' AS comment;";
			$stmt = $pdo->query( $sql );
		} else {
			$pdo->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );
			$pdo->setAttribute( PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC );
			$sql = <<<ESQL
				SELECT
					user_hub.id, user_hub.univ_id, user_hub.xoops_id, name, reading, organization, user_hub.comment, email,
					xoops, emg, news
				FROM
					user_hub LEFT JOIN emails ON user_hub.id=emails.user_id
				WHERE
					user_hub.id=?;
				ESQL;
			$stmt = $pdo->prepare( $sql );
			$stmt->execute( Array( $userId ) );
		}
		$members = $stmt->fetchAll();
		//
		// 個人情報
		//
		$member = $members[ 0 ];
		$addNew = ( $userId == 0 ) ? "" : "<a class=\"link_button\" href=\"{$selfUri}?view_id=0\">新規登録</a>";
		$delete = ( $userId == 0 ) ? "" : "<a id=\"delete_button\" class=\"link_button\" href=\"#\">削除</a> ";
		echo "<div class=\"top_navi\">" . $delete . $addNew . " <a class=\"link_button\" href=\"{$scriptHomeUri}/mailbox.php\">メールアカウント一覧</a> <a class=\"link_button\" href=\"{$selfUri}\">リストビュー</a></div>\n";
		echo "<div id=\"user_info\" class=\"mailbox\">\n";
		echo "<div class=\"listup\">\n";
		echo "<span class=\"reading\">よみ</span><span class=\"reading\">氏名</span><span class=\"reading\">所属</span><span class=\"member\">備考</span><br />\n";
		echo "<input type=\"hidden\" id=\"user_id\" value=\"{$userId}\" /> \n";
		echo "<input type=\"text\" id=\"reading\" value=\"{$member[ 'reading' ]}\" class=\"reading\" /> \n";
		echo "<input type=\"hidden\" id=\"reading_org\" value=\"{$member[ 'reading' ]}\" /> \n";
		echo "<input type=\"text\" id=\"name\" value=\"{$member[ 'name' ]}\" class=\"reading\" /> \n";
		echo "<input type=\"hidden\" id=\"name_org\" value=\"{$member[ 'name' ]}\" /> \n";
		echo "<input type=\"text\" id=\"organization\" value=\"{$member[ 'organization' ]}\" class=\"reading\" /> \n";
		echo "<input type=\"hidden\" id=\"organization_org\" value=\"{$member[ 'organization' ]}\" /> \n";
		echo "<input type=\"text\" id=\"comment\" value=\"{$member[ 'comment' ]}\" class=\"member\" />\n";
		echo "<input type=\"hidden\" id=\"comment_org\" value=\"{$member[ 'comment' ]}\" />\n";
		$btnTitle = ( $userId == 0 ) ? "登録" : "保存";
		echo "<button id=\"save_person_info\" type=\"button\">{$btnTitle}</button>";
		echo "</div><!-- listup -->\n";
		//
		// 個人情報に紐づいたメールアドレス情報
		//
		echo "<div class=\"inner_block\">\n";
		echo "<ul class=\"address_list\">\n";
		$i = 1;
		$checked = "checked=\"checked\" ";
		foreach ( $members as $member ) {
			if ( !isset( $member[ 'email' ] ) ) break;	// e-mail情報がなければ以下スキップ
//			$cc = $member[ 'cc' ] ? $checked : "";
//			$ml = $member[ 'ml' ] ? $checked : "";
			$xoops = $member[ 'xoops' ] ? $checked : "";
			$emg = $member[ 'emg' ] ? $checked : "";
			$news = $member[ 'news' ] ? $checked : "";
			echo "<li id=\"alis{$i}\">\n";
			echo "<input type=\"text\" id=\"email{$i}\" value=\"{$member[ 'email' ]}\" class=\"member\" readonly=\"readonly\" /> ";
			echo "<a id=\"mail_delete_button{$i}\" class=\"link_button mail_delete_button\" href=\"#\">削除</a><br />\n";
			echo "<div class=\"attention\">＊このメールアドレスは以下のアカウントの転送・配信先に設定されています。</div>\n";
			if ( $simultaneousMailingStatus ) {
				echo "<input class=\"readonly\" id=\"xoops\" type=\"checkbox\" readonly=\"readonly\" $xoops/><label for=\"xoops\">会員サイト</label> ";
//				echo "<input class=\"readonly\" id=\"ccs\" type=\"checkbox\" readonly=\"readonly\" $cc/><label for=\"ccs\">転送登録</label> ";
//				echo "<input class=\"readonly\" id=\"mls\" type=\"checkbox\" readonly=\"readonly\" $ml/><label for=\"mls\">ML登録</label> ";
				echo "<input class=\"readonly\" id=\"emg\" type=\"checkbox\" readonly=\"readonly\" $emg/><label for=\"emg\">緊急メール</label> ";
				echo "<input class=\"readonly\" id=\"news\" type=\"checkbox\" readonly=\"readonly\" $news/><label for=\"news\">おたよりメール</label> ";
			}
			$myCcs = $mails->searchAddressAllCc( $member[ 'email' ] );
			$myAccounts = array();
			foreach ( $myCcs as $myCc ) {
				$myAccounts[ $myCc[ 'email' ] ] = $myCc[ 'mod_envelope' ];
			}
			$ccs = $mails->getCcAccountList();
			echo "<h5>CC <a id=\"show_all_cc{$i}\" class=\"link_button\" href=\"#\">未登録アカウント表示</a> {$domainTag} <span id=\"status_cc{$i}\" class=\"status_area\"></span></h5>\n";
			echo "<ul id=\"cc{$i}\" class=\"cc\">\n";
			$gmailFilterStatus = "";
			$j = 1;
			foreach ( $ccs as $accountSet ) {
				$account = $accountSet[ 'account' ];
				$comment = $accountSet[ 'comment' ];
//				$envChecked = "<input id=\"mod_envelope{$i}_{$j}\" class=\"readonly\" type=\"checkbox\" $checked readonly=\"readonly\" />";
//				$envCheckNone = "<input id=\"mod_envelope{$i}_{$j}\" class=\"readonly\" type=\"checkbox\" readonly=\"readonly\" />";
				$registrationChecked = "<input id=\"registration{$i}_{$j}\" class=\"registration\" type=\"checkbox\" value=\"{$account}\" $checked />";
				$registrationCheckNone = "<input id=\"registration{$i}_{$j}\" class=\"registration\" type=\"checkbox\" value=\"{$account}\" />";
				$accountId = str_replace( ".", "_", $account );
				$accountLink = "<a href=\"{$scriptHomeUri}/mailbox.php#cc_{$accountId}\">{$account}</a>";
				if ( isset( $myAccounts[ $account ] ) ) {
//					$modEnvelope = $myAccounts[ $account ] == True ? $envChecked : $envCheckNone;
//					if ( $showGmailFilterStatus ) $gmailFilterStatus = "（{$modEnvelope}<label for=\"mod_envelope{$i}_{$j}\">Gmail対策</label>） ";
					echo "<li><span>{$gmailFilterStatus}{$registrationChecked} {$accountLink}</span><span>{$comment}</span></li>\n";
				} else {
//					if ( $showGmailFilterStatus ) $gmailFilterStatus = "（{$envCheckNone}<label for=\"mod_envelope{$i}_{$j}\">Gmail対策</label>） ";
					echo "<li class=\"not_registerated\"><span>{$gmailFilterStatus}{$registrationCheckNone} {$accountLink}</span><span>{$comment}</span></li>\n";
				}
				$j++;
			}
			echo "</ul>\n";
//			if ( count( $myCcs ) > 0 ) {
//				echo "<script type='text/javascript'>$( 'input#ccs' ).attr('checked', true).prop('checked', true).change();</script>\n";
//			} else {
//				echo "<script type='text/javascript'>$( 'input#ccs' ).removeAttr('checked').prop('checked', false).change();</script>\n";
//			}
			$myFmls = $mails->searchAddressAllFml( $member[ 'email' ] );
			$fmls = $mails->getFmlAccountList();
			echo "<h5>ML <a id=\"show_all_fml{$i}\" class=\"link_button\" href=\"#\">未登録アカウント表示</a> {$domainTag} <span id=\"status_fml{$i}\" class=\"status_area\"></span></h5>\n";
			echo "<ul id=\"ml{$i}\" class=\"ml\">\n";
			foreach ( $fmls as $accountSet ) {
				$account = $accountSet[ 'account' ];
				$comment = $accountSet[ 'comment' ];
				$accountId = str_replace( ".", "_", $account );
				$accountLink = "<a href=\"{$scriptHomeUri}/mailbox.php#fml_{$accountId}\">{$account}</a>";
				$registrationChecked = "<input id=\"registration{$i}_{$j}\" class=\"registration\" type=\"checkbox\" value=\"{$account}\" $checked />";
				$registrationCheckNone = "<input id=\"registration{$i}_{$j}\" class=\"registration\" type=\"checkbox\" value=\"{$account}\" />";
				if ( in_array( $account, $myFmls ) ) {
					echo "<li><span>{$registrationChecked} {$accountLink}</span><span>{$comment}</span></li>\n";
				} else {
					echo "<li class=\"not_registerated\"><span>{$registrationCheckNone} {$accountLink}</span><span>{$comment}</span></li>\n";
				}
				$j++;
			}
			echo "</ul>\n";
			if ( count( $myFmls ) > 0 ) {
				echo "<script type='text/javascript'>$( 'input#mls' ).attr('checked', true).prop('checked', true).change();</script>\n";
			} else {
				echo "<script type='text/javascript'>$( 'input#mls' ).removeAttr('checked').prop('checked', false).change();</script>\n";
			}
			$i++;
			echo "</li>\n";
		}
		echo "</ul></div><!-- inner_block -->\n";
		//
		// メールアドレス追加
		//
		if ( $userId > 0 ) {
			echo "<div class=\"inner_block align_right\">\n";
			echo "<input type=\"email\" id=\"email_new\" value=\"\" class=\"member\" /> ";
			echo "<button id=\"email_insert\" type=\"button\">メール追加登録</button>\n";
			echo "<input type=\"hidden\" id=\"email_new_org\" value=\"\" /> \n";
			echo "</div>\n";
		}
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
	if ( !getPropertyBool( 'disable_copyright' ) ) echo "<div class=\"copyright\">{$copyright}</div>";
	echo "</div>\n";
	echo "</div>\n";
}

function listView() {
	global $selfUri;
	global $selfUriQuery;
	global $scriptHomeUri;
	global $copyright;
	try {
		$pdo = new PDO( MAINDB_DSN );
		$pdo->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION );
		$pdo->setAttribute( PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC );
		$stmt = $pdo->prepare( "SELECT * FROM user_hub ORDER BY reading;" );
		$stmt->execute();
		$members = $stmt->fetchAll();
		if ( count( $members ) == 0 ) return false;
		echo "<div class=\"top_navi\">";
		echo "<span class=\"aiueo_filters\">";
		echo "<a id=\"yomi_a\" class=\"aiueo_filters\" href=\"#\">あ</a> ";
		echo "<a id=\"yomi_ka\" class=\"aiueo_filters\" href=\"#\">か</a> ";
		echo "<a id=\"yomi_sa\" class=\"aiueo_filters\" href=\"#\">さ</a> ";
		echo "<a id=\"yomi_ta\" class=\"aiueo_filters\" href=\"#\">た</a> ";
		echo "<a id=\"yomi_na\" class=\"aiueo_filters\" href=\"#\">な</a> ";
		echo "<a id=\"yomi_ha\" class=\"aiueo_filters\" href=\"#\">は</a> ";
		echo "<a id=\"yomi_ma\" class=\"aiueo_filters\" href=\"#\">ま</a> ";
		echo "<a id=\"yomi_ya\" class=\"aiueo_filters\" href=\"#\">や</a> ";
		echo "<a id=\"yomi_ra\" class=\"aiueo_filters\" href=\"#\">ら</a> ";
		echo "<a id=\"yomi_wa\" class=\"aiueo_filters\" href=\"#\">わ</a> ";
		echo "<a id=\"yomi_none\" class=\"aiueo_filters\" href=\"#\">それ以外</a> ";
		echo "<a id=\"yomi_all\" class=\"aiueo_filters\" href=\"#\">すべて</a> ";
		echo "</span> ";
		echo "<a class=\"link_button\" href=\"{$scriptHomeUri}/mailbox.php\">メールアカウント一覧</a> <a class=\"link_button\" href=\"{$selfUri}?view_id=0\">新規登録</a></div>\n";
		$searchArray = array(
			"yomi_a" => "あいうえお",
			"yomi_ka" => "かきくけこがぎぐげご",
			"yomi_sa" => "さしすせそざじずぜぞ",
			"yomi_ta" => "たちつてとだぢづでど",
			"yomi_na" => "なにぬねの",
			"yomi_ha" => "はひふへほばびぶべぼ",
			"yomi_ma" => "まみむめも",
			"yomi_ya" => "やゆよ",
			"yomi_ra" => "らりるれろ",
			"yomi_wa" => "わ"
		);
		echo "<div class=\"mailbox\">\n";
		echo "<table id=\"listview\" class=\"tablesorter-default listview\">\n";
		echo "<thead><tr><th class=\"middle\">よみがな</th><th class=\"middle\">氏名</th><th class=\"middle\">所属</th><th class=\"wide\">コメント</th><th class=\"narrow\">&nbsp;</th></tr></thead>\n";
		echo "<tbody>\n";
		$i = 1;
		foreach ( $members as $member ) {
			$initial = mb_substr( $member[ 'reading' ], 0, 1 );
			$aiueoId = "yomi_none";
			foreach ( $searchArray as $key => $aiueo ) {
				if ( strpos( $aiueo, $initial ) !== false ) {
					$aiueoId = $key;
					break;
				}
			}
			$oddEven = $i % 2 == 1 ? " odd" : " even";
			$oddEven = " odd";
			echo "<tr id=\"list{$member[ 'id' ]}\" class=\"{$aiueoId}{$oddEven}\">\n";
			echo "<td class=\"middle\">{$member[ 'reading' ]}</td>";
			echo "<td class=\"middle\"><a href=\"?view_id={$member[ 'id' ]}\">{$member[ 'name' ]}</a></td>";
			echo "<td class=\"middle\">{$member[ 'organization' ]}</td>";
			echo "<td class=\"wide\">{$member[ 'comment' ]}</td>";
			echo "<td class=\"narrow\"><a href=\"?view_id={$member[ 'id' ]}\" class=\"link_button\">編集</a></td>\n";
			echo "</tr>\n";
			$i++;
		}
		echo "</tbody></table>\n";
		echo "</div>\n";
		if ( !getPropertyBool( 'disable_copyright' ) ) echo "<div class=\"copyright\">{$copyright}</div>";
		echo "</div>\n";
		echo "</div>\n";
		$pdo = null;
		return true;
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
}

?>

</body>
</html>
