<html lang="ja">
<head>
<?php include( 'common.php' ); include( 'mail_handler.php' ); include( 'customize_fml.php' ); ?>
<meta charset="utf-8">
<link rel="stylesheet" href="<?php addUpdateQuery( "custom.css" ); ?>" />
<link rel="stylesheet" href="theme.default.min.css" />
<script src="jquery-3.7.1.min.js"></script>
<script src="jquery.cookie.js"></script>
<script src="jquery.tablesorter.min.js"></script>
<script src="<?php addUpdateQuery( "custom.js" ); ?>"></script>
</head>
<?php
/* =====================================================
	セッション管理
 ===================================================== */
$signinUser = "";
$isRoot = true;
if ( getPropertyBool( "session_control" ) || is_null( getProperty( "session_control" ) ) ) {
	$settingPage = "";
	session_name( SESSION_ID );
	session_start();
	if ( ! $_SESSION[ 'signin_id' ] ) die( file_get_contents( "forbidden.txt" ) );
	$isRoot = false;
	if ( $_SESSION[ 'root' ] ) $isRoot = true;
	$signinId = $_SESSION[ 'signin_id' ];
	$signinUser = $_SESSION[ 'signin_user' ];
	$exitMsg = ( $_SESSION[ 'home' ] ) ? "会員専用サイトへ戻る" : "サインアウト";
	$exitMsg = "<a href=\"{$scriptHomeUri}/\" class=\"link_button\">{$exitMsg}</a>";
	$signinIndicator = "user : ";
	$signinIndicator .= ( $_SESSION[ 'signin_user' ] ) ? $_SESSION[ 'signin_user' ] : $_SESSION[ 'signin_id' ];
}
//if ( $isRoot ) {
	$settingPage = " <a class=\"link_button\" href=\"{$scriptHomeUri}/settings.php\">設定</a> ";
	if ( $signinIndicator == "" ) {
		$signinIndicator = $settingPage;
	} else {
		$signinIndicator = $signinIndicator . $settingPage . $exitMsg;
	}
//} else {
//	$signinIndicator = $signinIndicator . $exitMsg;
//}

//
// mailハンドラクラスのセットアップ
//
$mails = new Mails( MAINDB_DSN );
$mails->setDefaultModEnvelope( getPropertyBool( "mod_envelope" ) );
$mails->setFmlPath( $fmlPath );
$mails->setMailPath( $mailPath );
?>

<!-- HTML メインボディ：ここから -->

<body>
<div class="signin_user"><?php echo $signinIndicator; ?></div>
<h1><?php echo $mainTitle ?></h1>
<h3>オプション設定</h3>
<div>
	<div class="outer_block">
<?php

echo "<input type=\"hidden\" id=\"signin_id\" value=\"{$signinId}\" />\n";
echo "<input type=\"hidden\" id=\"signin_user\" value=\"{$signinUser}\" />\n";
echo "<div class=\"top_navi\">\n<a class=\"link_button\" href=\"{$scriptHomeUri}/mailbox.php\">メールアカウント一覧</a> <a class=\"link_button\" href=\"{$scriptHomeUri}/members.php\">リストビュー</a>\n</div>\n";
if ( $isRoot ) settings( $mails );
userAdmin();
if ( $isRoot && !$demoMode ) update();
if ( !getPropertyBool( 'disable_copyright' ) ) echo "<div class=\"copyright\">{$copyright}</div>\n";
echo "</div><!-- outer_block -->\n";
echo "</div>\n";

/* end of main */

function settings( &$mails ) {
	global $scriptHomeUri;
	global $selfUri;
	try {
		$pdo = new PDO( MAINDB_DSN );
		$sql = "SELECT * FROM property ORDER BY key;";
		$properties = $pdo->query( $sql );
		echo "<h4>プロパティ</h4>\n";
		echo "<div id=\"status_area01\"></div>";
		echo "<div id=\"user_info\" class=\"mailbox\">\n";
		echo "<div class=\"listup\">\n";
		echo "<span class=\"check\">削除</span><span class=\"reading\">プロパティ名</span><span class=\"reading\">値</span><span class=\"member\">備考</span><br />\n";
		$i = 1;
		foreach ( $properties as $property ) {
			echo "<div id=\"property_{$i}\">\n";
			echo "<span class=\"check\"><input type=\"checkbox\" id=\"delete_{$i}\" class=\"check\" /></span>\n";
			echo "<input type=\"text\" id=\"key_{$i}\" value=\"{$property[ 'key' ]}\" class=\"reading readonly\" readonly=\"readonly\" />\n";
			echo "<input type=\"hidden\" id=\"property_org_{$i}\" value=\"{$property[ 'key' ]}\" /> \n";
			$boolClass = "";
			if ( in_array( strtoupper( $property[ 'value' ] ), array( 'YES', 'ON', 'TRUE' ) ) ) {
				$boolClass = ' true';
			}
			elseif ( in_array( strtoupper( $property[ 'value' ] ), array( 'NO', 'OFF', 'FALSE' ) ) ) {
				$boolClass = ' false';
			}
			echo "<input type=\"text\" id=\"value_{$i}\" value=\"{$property[ 'value' ]}\" class=\"bool_assist{$boolClass} reading\" />\n";
			echo "<input type=\"hidden\" id=\"value_org_{$i}\" value=\"{$property[ 'value' ]}\" />\n";
			echo "<input type=\"text\" id=\"comment_{$i}\" value=\"{$property[ 'comment' ]}\" class=\"member\" />\n";
			echo "<input type=\"hidden\" id=\"comment_org_{$i}\" value=\"{$property[ 'comment' ]}\" />\n";
			echo "<button id=\"save_property\" type=\"button\">確定</button>\n</div>\n";
			$i++;
		}
		//
		// 新規プロパティ追加欄
		//
		echo "<div id=\"property_{$i}\" class=\"new_data\">\n";
		echo "<span class=\"check\">新規</span>";
		echo "<input type=\"text\" id=\"key_{$i}\" value=\"\" class=\"reading\" />\n";
		echo "<input type=\"hidden\" id=\"key_org_{$i}\" value=\"*****\" />\n";
		echo "<input type=\"text\" id=\"value_{$i}\" value=\"\" class=\"bool_assist reading\" />\n";
		echo "<input type=\"hidden\" id=\"value_org_{$i}\" value=\"*****\" />\n";
		echo "<input type=\"text\" id=\"comment_{$i}\" value=\"\" class=\"member\" />\n";
		echo "<input type=\"hidden\" id=\"comment_org_{$i}\" value=\"*****\" />\n";
		echo "<button id=\"save_property\" type=\"button\">確定</button>\n</div>\n";
		echo "</div><!-- listup -->\n";
		echo "<p class=\"smaller indent20em\">* ON/OFF, YES/NO, TRUE/FALSE, 1/0 などは、項目をダブルクリックすると値を反転させられます。</p>\n";
		echo "</div><!-- mailbox -->\n";
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
} // settings

function userAdmin() {
	global $signinId;
	global $isRoot;
	try {
		$pdo = new PDO( MAINDB_DSN );
		$sql = "SELECT * FROM signin_info ORDER BY user;";
		$users = $pdo->query( $sql );
		echo "<h4>ユーザーID</h4>\n";
		echo "<div id=\"status_area02\"></div>";
		echo "<div id=\"user_info\" class=\"mailbox\" style=\"padding-bottom: 0.5em;\">\n";
		echo "<div class=\"listup\">\n";
		echo "<span class=\"check\">削除</span><span class=\"check\">管理者</span><span class=\"reading\">ユーザーID</span><span class=\"reading\">名前</span><span class=\"reading\">パスワード</span><br />\n";
		$disable ="";
		if ( !$isRoot ) $disable = 'disabled="disabled"';
		$i = 1;
		foreach ( $users as $user ) {
			if ( $isRoot || $signinId == $user[ 'user' ] ) {
				echo "<div id=\"user_{$i}\">\n";
				echo "<span class=\"check\"><input type=\"checkbox\" id=\"del_user_{$i}\" {$disable} /></span>\n";
				$checked = "";
				$value = "FALSE";
				if ( $user[ 'root' ] == 1 ) {
					$checked = " checked=\"checked\"";
					$value = "TRUE";
				}
				echo "<span class=\"check\"><input type=\"checkbox\" id=\"root_{$i}\" class=\"root_user\" value=\"{$value}\"{$checked} {$disable} /></span>\n";
				echo "<input type=\"hidden\" id=\"root_org_{$i}\" value=\"{$value}\" />\n";
				echo "<input type=\"text\" id=\"user_{$i}\" value=\"{$user[ 'user' ]}\" class=\"reading user_id readonly\" readonly=\"readonly\" />\n";
				echo "<input type=\"hidden\" id=\"user_org_{$i}\" value=\"{$user[ 'user' ]}\" />\n";
				echo "<input type=\"text\" id=\"user_name_{$i}\" value=\"{$user[ 'user_name' ]}\" class=\"reading\" />\n";
				echo "<input type=\"hidden\" id=\"user_name_org_{$i}\" value=\"{$user[ 'user_name' ]}\" />\n";
				echo "<input type=\"password\" id=\"password_{$i}\" value=\"\" class=\"reading\" placeholder=\"*************\" />\n";
				echo "<input type=\"hidden\" id=\"password_org_{$i}\" value=\"\" />\n";
				echo "<button id=\"save_user\" type=\"button\">確定</button>\n</div>\n";
				$i++;
			}
		}
		if ( $isRoot ) {
			echo "<div id=\"user_{$i}\" class=\"new_data\">\n";
			echo "<span class=\"check\">新規</span>\n";
			echo "<span class=\"check\"><input type=\"checkbox\" id=\"root_{$i}\" value=\"FALSE\" /></span>\n";
			echo "<input type=\"text\" id=\"user_{$i}\" value=\"\" class=\"reading\" />\n";
			echo "<input type=\"hidden\" id=\"user_org_{$i}\" value=\"\" />\n";
			echo "<input type=\"text\" id=\"user_name_{$i}\" value=\"\" class=\"reading\" />\n";
			echo "<input type=\"hidden\" id=\"user_name_org_{$i}\" value=\"\" />\n";
			echo "<input type=\"password\" id=\"password_{$i}\" value=\"\" class=\"reading\" />\n";
			echo "<input type=\"hidden\" id=\"password_org_{$i}\" value=\"\" />\n";
			echo "<button id=\"save_user\" type=\"button\">確定</button>\n</div>\n";
			echo "<p class=\"smaller indent20em\">* 管理者を必ず1名以上登録してください。</p>\n";
		}
		echo "</div><!-- listup -->\n";
		echo "</div><!-- mailbox -->\n";
	} catch ( Exception $e ) {
		echo $e->getMessage() . PHP_EOL;
	}
} // userAdmin

function update() {
	$sectionOpen = false;
	$sectionHeader = "<h4>更新</h4>\n";
	$sectionHeader .= "<div id=\"status_area03\"></div>\n";
	$sectionHeader .= "<div class=\"mailbox\" style=\"padding-bottom: 0.5em;\">\n";
	$sectionHeader .= "<div class=\"listup\">\n";
	$sectionFooter = "</div><!-- listup -->\n";
	$sectionFooter .= "</div><!-- mailbox -->\n";
	$archivePath = "https://noharajp.net/resource/smms/";
	$lines = file( "./version.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
	$currentVer = $lines[ 0 ];
	if ( getPropertyBool( 'check_beta' ) ) {
		$lines = file( $archivePath . "version_beta.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
		if ( $lines !== false ) {
			$betaVer = $lines[ 0 ];
			if ( version_compare( $betaVer, $currentVer ) > 0 ) {
				echo $sectionHeader;
				$sectionOpen = true;
				echo "<p>* ベータバージョンが見つかりました：";
				echo "<form action=\"update.php\" method=\"POST\"><input id=\"versionup_beta\" type=\"submit\" value=\"Ver.{$betaVer} に更新する\" />";
				echo "<input name=\"ver\" type=\"hidden\" value=\"beta\" />";
				echo "</form></p>";
			}
		}
	}
	$lines = file( $archivePath . "version.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
	if ( $lines === false ) {
		echo $sectionFooter;
		return;
	}
	$latestVer = $lines[ 0 ];
	if ( version_compare( $latestVer, $currentVer ) > 0 ) {
		if ( !$sectionOpen ) echo $sectionHeader;
		echo "<p>* 新しいバージョンが見つかりました：";
		echo "<form action=\"update.php\" method=\"POST\"><input id=\"versionup_latest\" type=\"submit\" value=\"Ver.{$latestVer} に更新する\" />";
		echo "<input name=\"ver\" type=\"hidden\" value=\"latest\" />";
		echo "</form></p>";
		$sectionOpen = true;
	}
	if ( $sectionOpen ) echo $sectionFooter;
} // update

?>
</body>
</html>
