<html lang="ja">
<head>
<?php include( 'common.php' ); ?>
<meta charset="utf-8">
<link rel="stylesheet" href="<?php addUpdateQuery( "custom.css" ); ?>" />
</head>
<?php
/* =====================================================
	セッション管理
 ===================================================== */
$signinUser = "";
$isRoot = true;
if ( getPropertyBool( "session_control" ) || is_null( getProperty( "session_control" ) ) ) {
	$settingPage = "";
	session_name( SESSION_ID );
	session_start();
	if ( ! $_SESSION[ 'signin_id' ] ) die( file_get_contents( "forbidden.txt" ) );
	$isRoot = false;
	if ( $_SESSION[ 'root' ] ) $isRoot = true;
	$signinId = $_SESSION[ 'signin_id' ];
	$signinUser = $_SESSION[ 'signin_user' ];
	$exitMsg = ( $_SESSION[ 'home' ] ) ? "会員専用サイトへ戻る" : "サインアウト";
	$exitMsg = "<a href=\"{$scriptHomeUri}/\" class=\"link_button\">{$exitMsg}</a>";
	$signinIndicator = "user : ";
	$signinIndicator .= ( $_SESSION[ 'signin_user' ] ) ? $_SESSION[ 'signin_user' ] : $_SESSION[ 'signin_id' ];
}
//if ( $isRoot ) {
	$settingPage = " <a class=\"link_button\" href=\"{$scriptHomeUri}/settings.php\">設定</a> ";
	if ( $signinIndicator == "" ) {
		$signinIndicator = $settingPage;
	} else {
		$signinIndicator = $signinIndicator . $settingPage . $exitMsg;
	}
//} else {
//	$signinIndicator = $signinIndicator . $exitMsg;
//}
?>

<body>
<div class="signin_user"><?php echo $signinIndicator; ?></div>
<h1><?php echo $mainTitle ?></h1>
<h3>バージョンの更新</h3>

<?php

$versionFile = "";
$zipFile = "";
if ( $_POST[ 'ver' ] == 'beta' ) {
	$versionFile = "version_beta.txt";
	$zipFile = "smms_beta.zip";
}
if ( $_POST[ 'ver' ] == 'latest' ) {
	$versionFile = "version.txt";
	$zipFile = "smms_latest.zip";
}
if ( $versionFile == "" ) die( file_get_contents( "forbidden.txt" ) );
$archivePath = "https://noharajp.net/resource/smms/";
$zipPath = $archivePath . $zipFile;
$targetPath = "./{$zipFile}";
$extractedDir = "smms";
$extractedPath = "./{$extractedDir}";

$unlinkList = array(
	"{$extractedPath}/install.php",
	"{$extractedPath}/update.php",
	"{$extractedPath}/db/emailhub.db",
	$targetPath
	);

$lines = file( "./version.txt", FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
$currentVer = $lines[ 0 ];
$lines = file( $archivePath . $versionFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES );
$latestVer = $lines[ 0 ];
if ( $currentVer == $latestVer ) {
	echo "<p>更新されたバージョンはありません。</p>";
} else {
	if ( file_exists( $extractedPath ) ) {
		system( "rm -rf {$extractedPath}" );
	}
	$ch = curl_init();
	curl_setopt_array( $ch, [
	CURLOPT_URL => $zipPath,
	CURLOPT_FILE => fopen( $targetPath, "wb" ),
	]);
	curl_exec($ch);
	if ( file_exists( $targetPath ) ) {
		$zip = new ZipArchive;
		if ( $zip->open( $targetPath ) === TRUE) {
			$zip->extractTo( '.' );
			$zip->close();
		} else {
			echo "<p>ダウンロードした書庫を開けませんでいた。</p>";
		}
	}
	if ( file_exists( $extractedPath ) ) {
		foreach ( $unlinkList as $path ) {
			unlink( $path );
		}
		copyDir( $extractedPath, '.' );
		system( "rm -rf {$extractedPath}" );
		$version .= " ==> " . "Ver." . $latestVer;
		try {
			$pdo = new PDO( MAINDB_DSN );
			$unixTime = time();
			$sql = "INSERT INTO log ( action, account, account_owner, data, signin_id, signin_user, time ) VALUES ( 'VERSION_UP', :account, '', :data, :signin_id, :signin_user, :time );";
			$stmt = $pdo->prepare( $sql );
			$stmt->bindParam( ":account", $_POST[ 'ver' ], PDO::PARAM_STR );
			$stmt->bindParam( ":data", $version, PDO::PARAM_STR );
			$stmt->bindParam( ":signin_id", $_SESSION[ 'signin_id' ], PDO::PARAM_STR );
			$stmt->bindParam( ":signin_user", $_SESSION[ 'signin_user' ], PDO::PARAM_STR );
			$stmt->bindParam( ":time", $unixTime, PDO::PARAM_INT );
			$stmt->execute();
		} catch ( Exception $e ) {
			echo $e->getMessage();
		}
		echo "<p>Ver.{$latestVer} に更新しました。</p>";
	} else {
		echo "<p>ダウンロードした書庫を展開できませんでいた。</p>";
	}
}

/**
 * ディレクトリをコピーする
 *
 * @param string $fromDir コピー元ディレクトリ
 * @param string $toDir コピー先ディレクトリ
 * @return void
 */
function copyDir($fromDir, $toDir)
{
	$fromDir = rtrim($fromDir, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;
	$toDir   = rtrim($toDir, DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR;

	// コピー元がない場合は終了
	if (!is_dir($fromDir)) {
		return;
	}

	// ディレクトリがない場合は作成する
	if (!is_dir($toDir)) {
		mkdir($toDir, 0777);
		chmod($toDir, 0777);
	}

	if ($handle = opendir($fromDir)) {
		while (false !== ($file = readdir($handle))) {
			if ($file === '.' || $file === '..') {
				continue;
			}

			// ディレクトリの場合は再帰処理を行う
			if (is_dir($fromDir.$file)) {
				copyDir($fromDir.$file, $toDir.$file);
			} else {
				$currentTimestamp = filemtime($fromDir.$file);
				copy($fromDir.$file, $toDir.$file);
				touch($toDir.$file, $currentTimestamp);
			}
		}
		closedir($handle);
	}
}

?>
</body>
</html>
